// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The customer name to be printed on a letter of authorization. */
@Fluent
public final class GenerateExpressRoutePortsLoaRequest {
    /*
     * The customer name.
     */
    @JsonProperty(value = "customerName", required = true)
    private String customerName;

    /** Creates an instance of GenerateExpressRoutePortsLoaRequest class. */
    public GenerateExpressRoutePortsLoaRequest() {
    }

    /**
     * Get the customerName property: The customer name.
     *
     * @return the customerName value.
     */
    public String customerName() {
        return this.customerName;
    }

    /**
     * Set the customerName property: The customer name.
     *
     * @param customerName the customerName value to set.
     * @return the GenerateExpressRoutePortsLoaRequest object itself.
     */
    public GenerateExpressRoutePortsLoaRequest withCustomerName(String customerName) {
        this.customerName = customerName;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (customerName() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property customerName in model GenerateExpressRoutePortsLoaRequest"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GenerateExpressRoutePortsLoaRequest.class);
}
