// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Public IP addresses associated with azure firewall. */
@Fluent
public final class HubPublicIpAddresses {
    /*
     * The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
     */
    @JsonProperty(value = "addresses")
    private List<AzureFirewallPublicIpAddress> addresses;

    /*
     * The number of Public IP addresses associated with azure firewall.
     */
    @JsonProperty(value = "count")
    private Integer count;

    /** Creates an instance of HubPublicIpAddresses class. */
    public HubPublicIpAddresses() {
    }

    /**
     * Get the addresses property: The list of Public IP addresses associated with azure firewall or IP addresses to be
     * retained.
     *
     * @return the addresses value.
     */
    public List<AzureFirewallPublicIpAddress> addresses() {
        return this.addresses;
    }

    /**
     * Set the addresses property: The list of Public IP addresses associated with azure firewall or IP addresses to be
     * retained.
     *
     * @param addresses the addresses value to set.
     * @return the HubPublicIpAddresses object itself.
     */
    public HubPublicIpAddresses withAddresses(List<AzureFirewallPublicIpAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    /**
     * Get the count property: The number of Public IP addresses associated with azure firewall.
     *
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: The number of Public IP addresses associated with azure firewall.
     *
     * @param count the count value to set.
     * @return the HubPublicIpAddresses object itself.
     */
    public HubPublicIpAddresses withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (addresses() != null) {
            addresses().forEach(e -> e.validate());
        }
    }
}
