// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains IPv6 peering config. */
@Fluent
public final class Ipv6ExpressRouteCircuitPeeringConfig {
    /*
     * The primary address prefix.
     */
    @JsonProperty(value = "primaryPeerAddressPrefix")
    private String primaryPeerAddressPrefix;

    /*
     * The secondary address prefix.
     */
    @JsonProperty(value = "secondaryPeerAddressPrefix")
    private String secondaryPeerAddressPrefix;

    /*
     * The Microsoft peering configuration.
     */
    @JsonProperty(value = "microsoftPeeringConfig")
    private ExpressRouteCircuitPeeringConfig microsoftPeeringConfig;

    /*
     * The reference to the RouteFilter resource.
     */
    @JsonProperty(value = "routeFilter")
    private SubResource routeFilter;

    /*
     * The state of peering.
     */
    @JsonProperty(value = "state")
    private ExpressRouteCircuitPeeringState state;

    /** Creates an instance of Ipv6ExpressRouteCircuitPeeringConfig class. */
    public Ipv6ExpressRouteCircuitPeeringConfig() {
    }

    /**
     * Get the primaryPeerAddressPrefix property: The primary address prefix.
     *
     * @return the primaryPeerAddressPrefix value.
     */
    public String primaryPeerAddressPrefix() {
        return this.primaryPeerAddressPrefix;
    }

    /**
     * Set the primaryPeerAddressPrefix property: The primary address prefix.
     *
     * @param primaryPeerAddressPrefix the primaryPeerAddressPrefix value to set.
     * @return the Ipv6ExpressRouteCircuitPeeringConfig object itself.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig withPrimaryPeerAddressPrefix(String primaryPeerAddressPrefix) {
        this.primaryPeerAddressPrefix = primaryPeerAddressPrefix;
        return this;
    }

    /**
     * Get the secondaryPeerAddressPrefix property: The secondary address prefix.
     *
     * @return the secondaryPeerAddressPrefix value.
     */
    public String secondaryPeerAddressPrefix() {
        return this.secondaryPeerAddressPrefix;
    }

    /**
     * Set the secondaryPeerAddressPrefix property: The secondary address prefix.
     *
     * @param secondaryPeerAddressPrefix the secondaryPeerAddressPrefix value to set.
     * @return the Ipv6ExpressRouteCircuitPeeringConfig object itself.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig withSecondaryPeerAddressPrefix(String secondaryPeerAddressPrefix) {
        this.secondaryPeerAddressPrefix = secondaryPeerAddressPrefix;
        return this;
    }

    /**
     * Get the microsoftPeeringConfig property: The Microsoft peering configuration.
     *
     * @return the microsoftPeeringConfig value.
     */
    public ExpressRouteCircuitPeeringConfig microsoftPeeringConfig() {
        return this.microsoftPeeringConfig;
    }

    /**
     * Set the microsoftPeeringConfig property: The Microsoft peering configuration.
     *
     * @param microsoftPeeringConfig the microsoftPeeringConfig value to set.
     * @return the Ipv6ExpressRouteCircuitPeeringConfig object itself.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig withMicrosoftPeeringConfig(
        ExpressRouteCircuitPeeringConfig microsoftPeeringConfig) {
        this.microsoftPeeringConfig = microsoftPeeringConfig;
        return this;
    }

    /**
     * Get the routeFilter property: The reference to the RouteFilter resource.
     *
     * @return the routeFilter value.
     */
    public SubResource routeFilter() {
        return this.routeFilter;
    }

    /**
     * Set the routeFilter property: The reference to the RouteFilter resource.
     *
     * @param routeFilter the routeFilter value to set.
     * @return the Ipv6ExpressRouteCircuitPeeringConfig object itself.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig withRouteFilter(SubResource routeFilter) {
        this.routeFilter = routeFilter;
        return this;
    }

    /**
     * Get the state property: The state of peering.
     *
     * @return the state value.
     */
    public ExpressRouteCircuitPeeringState state() {
        return this.state;
    }

    /**
     * Set the state property: The state of peering.
     *
     * @param state the state value to set.
     * @return the Ipv6ExpressRouteCircuitPeeringConfig object itself.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig withState(ExpressRouteCircuitPeeringState state) {
        this.state = state;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (microsoftPeeringConfig() != null) {
            microsoftPeeringConfig().validate();
        }
    }
}
