// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** VirtualNetworkGatewaySku details. */
@Fluent
public final class VirtualNetworkGatewaySku {
    /*
     * Gateway SKU name.
     */
    @JsonProperty(value = "name")
    private VirtualNetworkGatewaySkuName name;

    /*
     * Gateway SKU tier.
     */
    @JsonProperty(value = "tier")
    private VirtualNetworkGatewaySkuTier tier;

    /*
     * The capacity.
     */
    @JsonProperty(value = "capacity", access = JsonProperty.Access.WRITE_ONLY)
    private Integer capacity;

    /** Creates an instance of VirtualNetworkGatewaySku class. */
    public VirtualNetworkGatewaySku() {
    }

    /**
     * Get the name property: Gateway SKU name.
     *
     * @return the name value.
     */
    public VirtualNetworkGatewaySkuName name() {
        return this.name;
    }

    /**
     * Set the name property: Gateway SKU name.
     *
     * @param name the name value to set.
     * @return the VirtualNetworkGatewaySku object itself.
     */
    public VirtualNetworkGatewaySku withName(VirtualNetworkGatewaySkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: Gateway SKU tier.
     *
     * @return the tier value.
     */
    public VirtualNetworkGatewaySkuTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: Gateway SKU tier.
     *
     * @param tier the tier value to set.
     * @return the VirtualNetworkGatewaySku object itself.
     */
    public VirtualNetworkGatewaySku withTier(VirtualNetworkGatewaySkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Get the capacity property: The capacity.
     *
     * @return the capacity value.
     */
    public Integer capacity() {
        return this.capacity;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
