/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.NetworkVirtualAppliancePropertiesFormat;
import com.azure.resourcemanager.network.models.DelegationProperties;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.PartnerManagedResourceProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualApplianceAdditionalNicProperties;
import com.azure.resourcemanager.network.models.VirtualApplianceNicProperties;
import com.azure.resourcemanager.network.models.VirtualApplianceSkuProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class NetworkVirtualApplianceInner
extends Resource {
    @JsonProperty(value="properties")
    private NetworkVirtualAppliancePropertiesFormat innerProperties;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private NetworkVirtualAppliancePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public NetworkVirtualApplianceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public NetworkVirtualApplianceInner withId(String id) {
        this.id = id;
        return this;
    }

    public NetworkVirtualApplianceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetworkVirtualApplianceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public VirtualApplianceSkuProperties nvaSku() {
        return this.innerProperties() == null ? null : this.innerProperties().nvaSku();
    }

    public NetworkVirtualApplianceInner withNvaSku(VirtualApplianceSkuProperties nvaSku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withNvaSku(nvaSku);
        return this;
    }

    public String addressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefix();
    }

    public List<String> bootStrapConfigurationBlobs() {
        return this.innerProperties() == null ? null : this.innerProperties().bootStrapConfigurationBlobs();
    }

    public NetworkVirtualApplianceInner withBootStrapConfigurationBlobs(List<String> bootStrapConfigurationBlobs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withBootStrapConfigurationBlobs(bootStrapConfigurationBlobs);
        return this;
    }

    public SubResource virtualHub() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHub();
    }

    public NetworkVirtualApplianceInner withVirtualHub(SubResource virtualHub) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withVirtualHub(virtualHub);
        return this;
    }

    public List<String> cloudInitConfigurationBlobs() {
        return this.innerProperties() == null ? null : this.innerProperties().cloudInitConfigurationBlobs();
    }

    public NetworkVirtualApplianceInner withCloudInitConfigurationBlobs(List<String> cloudInitConfigurationBlobs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withCloudInitConfigurationBlobs(cloudInitConfigurationBlobs);
        return this;
    }

    public String cloudInitConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().cloudInitConfiguration();
    }

    public NetworkVirtualApplianceInner withCloudInitConfiguration(String cloudInitConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withCloudInitConfiguration(cloudInitConfiguration);
        return this;
    }

    public Long virtualApplianceAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualApplianceAsn();
    }

    public NetworkVirtualApplianceInner withVirtualApplianceAsn(Long virtualApplianceAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withVirtualApplianceAsn(virtualApplianceAsn);
        return this;
    }

    public String sshPublicKey() {
        return this.innerProperties() == null ? null : this.innerProperties().sshPublicKey();
    }

    public NetworkVirtualApplianceInner withSshPublicKey(String sshPublicKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withSshPublicKey(sshPublicKey);
        return this;
    }

    public List<VirtualApplianceNicProperties> virtualApplianceNics() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualApplianceNics();
    }

    public List<VirtualApplianceAdditionalNicProperties> additionalNics() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalNics();
    }

    public NetworkVirtualApplianceInner withAdditionalNics(List<VirtualApplianceAdditionalNicProperties> additionalNics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withAdditionalNics(additionalNics);
        return this;
    }

    public List<SubResource> virtualApplianceSites() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualApplianceSites();
    }

    public List<SubResource> virtualApplianceConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualApplianceConnections();
    }

    public List<SubResource> inboundSecurityRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundSecurityRules();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String deploymentType() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentType();
    }

    public DelegationProperties delegation() {
        return this.innerProperties() == null ? null : this.innerProperties().delegation();
    }

    public NetworkVirtualApplianceInner withDelegation(DelegationProperties delegation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withDelegation(delegation);
        return this;
    }

    public PartnerManagedResourceProperties partnerManagedResource() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerManagedResource();
    }

    public NetworkVirtualApplianceInner withPartnerManagedResource(PartnerManagedResourceProperties partnerManagedResource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withPartnerManagedResource(partnerManagedResource);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

