// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Connectivity topology type. */
public final class ConnectivityTopology extends ExpandableStringEnum<ConnectivityTopology> {
    /** Static value HubAndSpoke for ConnectivityTopology. */
    public static final ConnectivityTopology HUB_AND_SPOKE = fromString("HubAndSpoke");

    /** Static value Mesh for ConnectivityTopology. */
    public static final ConnectivityTopology MESH = fromString("Mesh");

    /**
     * Creates a new instance of ConnectivityTopology value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ConnectivityTopology() {
    }

    /**
     * Creates or finds a ConnectivityTopology from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ConnectivityTopology.
     */
    @JsonCreator
    public static ConnectivityTopology fromString(String name) {
        return fromString(name, ConnectivityTopology.class);
    }

    /**
     * Gets known ConnectivityTopology values.
     *
     * @return known ConnectivityTopology values.
     */
    public static Collection<ConnectivityTopology> values() {
        return values(ConnectivityTopology.class);
    }
}
