// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.ScopeConnectionState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Scope connection. */
@Fluent
public final class ScopeConnectionProperties {
    /*
     * Tenant ID.
     */
    @JsonProperty(value = "tenantId")
    private String tenantId;

    /*
     * Resource ID.
     */
    @JsonProperty(value = "resourceId")
    private String resourceId;

    /*
     * Connection State
     */
    @JsonProperty(value = "connectionState", access = JsonProperty.Access.WRITE_ONLY)
    private ScopeConnectionState connectionState;

    /*
     * A description of the scope connection.
     */
    @JsonProperty(value = "description")
    private String description;

    /** Creates an instance of ScopeConnectionProperties class. */
    public ScopeConnectionProperties() {
    }

    /**
     * Get the tenantId property: Tenant ID.
     *
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: Tenant ID.
     *
     * @param tenantId the tenantId value to set.
     * @return the ScopeConnectionProperties object itself.
     */
    public ScopeConnectionProperties withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the resourceId property: Resource ID.
     *
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Resource ID.
     *
     * @param resourceId the resourceId value to set.
     * @return the ScopeConnectionProperties object itself.
     */
    public ScopeConnectionProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the connectionState property: Connection State.
     *
     * @return the connectionState value.
     */
    public ScopeConnectionState connectionState() {
        return this.connectionState;
    }

    /**
     * Get the description property: A description of the scope connection.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description of the scope connection.
     *
     * @param description the description value to set.
     * @return the ScopeConnectionProperties object itself.
     */
    public ScopeConnectionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
