// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.RoutingIntentsClient;
import com.azure.resourcemanager.network.fluent.models.RoutingIntentInner;
import com.azure.resourcemanager.network.models.ListRoutingIntentResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RoutingIntentsClient. */
public final class RoutingIntentsClientImpl implements RoutingIntentsClient {
    /** The proxy service used to perform REST calls. */
    private final RoutingIntentsService service;

    /** The service client containing this operation class. */
    private final NetworkManagementClientImpl client;

    /**
     * Initializes an instance of RoutingIntentsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    RoutingIntentsClientImpl(NetworkManagementClientImpl client) {
        this.service =
            RestProxy.create(RoutingIntentsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for NetworkManagementClientRoutingIntents to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "NetworkManagementCli")
    public interface RoutingIntentsService {
        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routingIntent/{routingIntentName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualHubName") String virtualHubName,
            @PathParam("routingIntentName") String routingIntentName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RoutingIntentInner routingIntentParameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routingIntent/{routingIntentName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoutingIntentInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualHubName") String virtualHubName,
            @PathParam("routingIntentName") String routingIntentName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routingIntent/{routingIntentName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualHubName") String virtualHubName,
            @PathParam("routingIntentName") String routingIntentName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routingIntent")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ListRoutingIntentResult>> list(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualHubName") String virtualHubName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ListRoutingIntentResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Creates a RoutingIntent resource if it doesn't exist else updates the existing RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
     * @param routingIntentParameters Parameters supplied to create or update RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String virtualHubName,
        String routingIntentName,
        RoutingIntentInner routingIntentParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        if (routingIntentParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter routingIntentParameters is required and cannot be null."));
        } else {
            routingIntentParameters.validate();
        }
        final String apiVersion = "2023-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualHubName,
                            routingIntentName,
                            apiVersion,
                            routingIntentParameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a RoutingIntent resource if it doesn't exist else updates the existing RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
     * @param routingIntentParameters Parameters supplied to create or update RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String virtualHubName,
        String routingIntentName,
        RoutingIntentInner routingIntentParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        if (routingIntentParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter routingIntentParameters is required and cannot be null."));
        } else {
            routingIntentParameters.validate();
        }
        final String apiVersion = "2023-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualHubName,
                routingIntentName,
                apiVersion,
                routingIntentParameters,
                accept,
                context);
    }

    /**
     * Creates a RoutingIntent resource if it doesn't exist else updates the existing RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
     * @param routingIntentParameters Parameters supplied to create or update RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the routing intent child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RoutingIntentInner>, RoutingIntentInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String virtualHubName,
        String routingIntentName,
        RoutingIntentInner routingIntentParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters);
        return this
            .client
            .<RoutingIntentInner, RoutingIntentInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                RoutingIntentInner.class,
                RoutingIntentInner.class,
                this.client.getContext());
    }

    /**
     * Creates a RoutingIntent resource if it doesn't exist else updates the existing RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
     * @param routingIntentParameters Parameters supplied to create or update RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the routing intent child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RoutingIntentInner>, RoutingIntentInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String virtualHubName,
        String routingIntentName,
        RoutingIntentInner routingIntentParameters,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters, context);
        return this
            .client
            .<RoutingIntentInner, RoutingIntentInner>getLroResult(
                mono, this.client.getHttpPipeline(), RoutingIntentInner.class, RoutingIntentInner.class, context);
    }

    /**
     * Creates a RoutingIntent resource if it doesn't exist else updates the existing RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
     * @param routingIntentParameters Parameters supplied to create or update RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the routing intent child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RoutingIntentInner>, RoutingIntentInner> beginCreateOrUpdate(
        String resourceGroupName,
        String virtualHubName,
        String routingIntentName,
        RoutingIntentInner routingIntentParameters) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters)
            .getSyncPoller();
    }

    /**
     * Creates a RoutingIntent resource if it doesn't exist else updates the existing RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
     * @param routingIntentParameters Parameters supplied to create or update RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the routing intent child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RoutingIntentInner>, RoutingIntentInner> beginCreateOrUpdate(
        String resourceGroupName,
        String virtualHubName,
        String routingIntentName,
        RoutingIntentInner routingIntentParameters,
        Context context) {
        return this
            .beginCreateOrUpdateAsync(
                resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters, context)
            .getSyncPoller();
    }

    /**
     * Creates a RoutingIntent resource if it doesn't exist else updates the existing RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
     * @param routingIntentParameters Parameters supplied to create or update RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoutingIntentInner> createOrUpdateAsync(
        String resourceGroupName,
        String virtualHubName,
        String routingIntentName,
        RoutingIntentInner routingIntentParameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a RoutingIntent resource if it doesn't exist else updates the existing RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
     * @param routingIntentParameters Parameters supplied to create or update RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<RoutingIntentInner> createOrUpdateAsync(
        String resourceGroupName,
        String virtualHubName,
        String routingIntentName,
        RoutingIntentInner routingIntentParameters,
        Context context) {
        return beginCreateOrUpdateAsync(
                resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a RoutingIntent resource if it doesn't exist else updates the existing RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
     * @param routingIntentParameters Parameters supplied to create or update RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoutingIntentInner createOrUpdate(
        String resourceGroupName,
        String virtualHubName,
        String routingIntentName,
        RoutingIntentInner routingIntentParameters) {
        return createOrUpdateAsync(resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters)
            .block();
    }

    /**
     * Creates a RoutingIntent resource if it doesn't exist else updates the existing RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the per VirtualHub singleton Routing Intent resource.
     * @param routingIntentParameters Parameters supplied to create or update RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoutingIntentInner createOrUpdate(
        String resourceGroupName,
        String virtualHubName,
        String routingIntentName,
        RoutingIntentInner routingIntentParameters,
        Context context) {
        return createOrUpdateAsync(
                resourceGroupName, virtualHubName, routingIntentName, routingIntentParameters, context)
            .block();
    }

    /**
     * Retrieves the details of a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoutingIntentInner>> getWithResponseAsync(
        String resourceGroupName, String virtualHubName, String routingIntentName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        final String apiVersion = "2023-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualHubName,
                            routingIntentName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the details of a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoutingIntentInner>> getWithResponseAsync(
        String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        final String apiVersion = "2023-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualHubName,
                routingIntentName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Retrieves the details of a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoutingIntentInner> getAsync(
        String resourceGroupName, String virtualHubName, String routingIntentName) {
        return getWithResponseAsync(resourceGroupName, virtualHubName, routingIntentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves the details of a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoutingIntentInner> getWithResponse(
        String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        return getWithResponseAsync(resourceGroupName, virtualHubName, routingIntentName, context).block();
    }

    /**
     * Retrieves the details of a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the routing intent child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoutingIntentInner get(String resourceGroupName, String virtualHubName, String routingIntentName) {
        return getWithResponse(resourceGroupName, virtualHubName, routingIntentName, Context.NONE).getValue();
    }

    /**
     * Deletes a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String virtualHubName, String routingIntentName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        final String apiVersion = "2023-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualHubName,
                            routingIntentName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routingIntentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter routingIntentName is required and cannot be null."));
        }
        final String apiVersion = "2023-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualHubName,
                routingIntentName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Deletes a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String virtualHubName, String routingIntentName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, virtualHubName, routingIntentName);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Deletes a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, virtualHubName, routingIntentName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String virtualHubName, String routingIntentName) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, routingIntentName).getSyncPoller();
    }

    /**
     * Deletes a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, virtualHubName, routingIntentName, context).getSyncPoller();
    }

    /**
     * Deletes a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routingIntentName) {
        return beginDeleteAsync(resourceGroupName, virtualHubName, routingIntentName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        return beginDeleteAsync(resourceGroupName, virtualHubName, routingIntentName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualHubName, String routingIntentName) {
        deleteAsync(resourceGroupName, virtualHubName, routingIntentName).block();
    }

    /**
     * Deletes a RoutingIntent.
     *
     * @param resourceGroupName The resource group name of the RoutingIntent.
     * @param virtualHubName The name of the VirtualHub.
     * @param routingIntentName The name of the RoutingIntent.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualHubName, String routingIntentName, Context context) {
        deleteAsync(resourceGroupName, virtualHubName, routingIntentName, context).block();
    }

    /**
     * Retrieves the details of all RoutingIntent child resources of the VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of the routing intent result and a URL nextLink to get the next set of results along with {@link
     *     PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoutingIntentInner>> listSinglePageAsync(
        String resourceGroupName, String virtualHubName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        final String apiVersion = "2023-02-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualHubName,
                            apiVersion,
                            accept,
                            context))
            .<PagedResponse<RoutingIntentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the details of all RoutingIntent child resources of the VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of the routing intent result and a URL nextLink to get the next set of results along with {@link
     *     PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoutingIntentInner>> listSinglePageAsync(
        String resourceGroupName, String virtualHubName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        final String apiVersion = "2023-02-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualHubName,
                apiVersion,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Retrieves the details of all RoutingIntent child resources of the VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of the routing intent result and a URL nextLink to get the next set of results as paginated response
     *     with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoutingIntentInner> listAsync(String resourceGroupName, String virtualHubName) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, virtualHubName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves the details of all RoutingIntent child resources of the VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of the routing intent result and a URL nextLink to get the next set of results as paginated response
     *     with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RoutingIntentInner> listAsync(String resourceGroupName, String virtualHubName, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, virtualHubName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves the details of all RoutingIntent child resources of the VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of the routing intent result and a URL nextLink to get the next set of results as paginated response
     *     with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoutingIntentInner> list(String resourceGroupName, String virtualHubName) {
        return new PagedIterable<>(listAsync(resourceGroupName, virtualHubName));
    }

    /**
     * Retrieves the details of all RoutingIntent child resources of the VirtualHub.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of the routing intent result and a URL nextLink to get the next set of results as paginated response
     *     with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoutingIntentInner> list(String resourceGroupName, String virtualHubName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, virtualHubName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of the routing intent result and a URL nextLink to get the next set of results along with {@link
     *     PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoutingIntentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<RoutingIntentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of the routing intent result and a URL nextLink to get the next set of results along with {@link
     *     PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoutingIntentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
