// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.VirtualHubInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Result of the request to list VirtualHubs. It contains a list of VirtualHubs and a URL nextLink to get the next set
 * of results.
 */
@Fluent
public final class ListVirtualHubsResult {
    /*
     * List of VirtualHubs.
     */
    @JsonProperty(value = "value")
    private List<VirtualHubInner> value;

    /*
     * URL to get the next set of operation list results if there are any.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of ListVirtualHubsResult class. */
    public ListVirtualHubsResult() {
    }

    /**
     * Get the value property: List of VirtualHubs.
     *
     * @return the value value.
     */
    public List<VirtualHubInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of VirtualHubs.
     *
     * @param value the value value to set.
     * @return the ListVirtualHubsResult object itself.
     */
    public ListVirtualHubsResult withValue(List<VirtualHubInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of operation list results if there are any.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of operation list results if there are any.
     *
     * @param nextLink the nextLink value to set.
     * @return the ListVirtualHubsResult object itself.
     */
    public ListVirtualHubsResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
