/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.ApplicationGatewaysClient;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayAuthenticationCertificateInner;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayProbeInner;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayRedirectConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayRequestRoutingRuleInner;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewaySslCertificateInner;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayUrlPathMapInner;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayAuthenticationCertificateImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayBackendHealthImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayBackendHttpConfigurationImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayBackendImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayFrontendImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayIpConfigurationImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayListenerImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayProbeImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayRedirectConfigurationImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayRequestRoutingRuleImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewaySslCertificateImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayUrlPathMapImpl;
import com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayAuthenticationCertificate;
import com.azure.resourcemanager.network.models.ApplicationGatewayAutoscaleConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddressPool;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHealth;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHealthPool;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpSettings;
import com.azure.resourcemanager.network.models.ApplicationGatewayFirewallMode;
import com.azure.resourcemanager.network.models.ApplicationGatewayFrontend;
import com.azure.resourcemanager.network.models.ApplicationGatewayFrontendIpConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayFrontendPort;
import com.azure.resourcemanager.network.models.ApplicationGatewayHttpListener;
import com.azure.resourcemanager.network.models.ApplicationGatewayIpConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayListener;
import com.azure.resourcemanager.network.models.ApplicationGatewayOperationalState;
import com.azure.resourcemanager.network.models.ApplicationGatewayProbe;
import com.azure.resourcemanager.network.models.ApplicationGatewayRedirectConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayRequestRoutingRule;
import com.azure.resourcemanager.network.models.ApplicationGatewayRequestRoutingRuleType;
import com.azure.resourcemanager.network.models.ApplicationGatewaySku;
import com.azure.resourcemanager.network.models.ApplicationGatewaySkuName;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslCertificate;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslPolicy;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslProtocol;
import com.azure.resourcemanager.network.models.ApplicationGatewayTier;
import com.azure.resourcemanager.network.models.ApplicationGatewayUrlPathMap;
import com.azure.resourcemanager.network.models.ApplicationGatewayWebApplicationFirewallConfiguration;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.KnownWebApplicationGatewayManagedRuleSet;
import com.azure.resourcemanager.network.models.ManagedRuleGroupOverride;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.network.models.WebApplicationFirewallMode;
import com.azure.resourcemanager.network.models.WebApplicationFirewallPolicy;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ApplicationGatewayImpl
extends GroupableParentResourceWithTagsImpl<ApplicationGateway, ApplicationGatewayInner, ApplicationGatewayImpl, NetworkManager>
implements ApplicationGateway,
ApplicationGateway.Definition,
ApplicationGateway.Update {
    private Map<String, ApplicationGatewayIpConfiguration> ipConfigs;
    private Map<String, ApplicationGatewayFrontend> frontends;
    private Map<String, ApplicationGatewayProbe> probes;
    private Map<String, ApplicationGatewayBackend> backends;
    private Map<String, ApplicationGatewayBackendHttpConfiguration> backendConfigs;
    private Map<String, ApplicationGatewayListener> listeners;
    private Map<String, ApplicationGatewayRequestRoutingRule> rules;
    private AddedRuleCollection addedRuleCollection;
    private Map<String, ApplicationGatewaySslCertificate> sslCerts;
    private Map<String, ApplicationGatewayAuthenticationCertificate> authCertificates;
    private Map<String, ApplicationGatewayRedirectConfiguration> redirectConfigs;
    private Map<String, ApplicationGatewayUrlPathMap> urlPathMaps;
    private static final String DEFAULT = "default";
    private ApplicationGatewayFrontendImpl defaultPrivateFrontend;
    private ApplicationGatewayFrontendImpl defaultPublicFrontend;
    private Map<String, String> creatablePipsByFrontend;
    private String creatableWafPolicy;
    private boolean legacyWafConfigurationSpecifiedInCreate = false;
    private Creatable<Network> creatableNetwork = null;
    private Creatable<PublicIpAddress> creatablePip = null;

    ApplicationGatewayImpl(String name, ApplicationGatewayInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    public Mono<ApplicationGateway> refreshAsync() {
        return super.refreshAsync().map(applicationGateway -> {
            ApplicationGatewayImpl impl = (ApplicationGatewayImpl)applicationGateway;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    protected Mono<ApplicationGatewayInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getApplicationGateways().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    protected Mono<ApplicationGatewayInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getApplicationGateways().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((ApplicationGatewayInner)((Object)this.innerModel())).tags()));
    }

    protected void initializeChildrenFromInner() {
        this.initializeConfigsFromInner();
        this.initializeFrontendsFromInner();
        this.initializeProbesFromInner();
        this.initializeBackendsFromInner();
        this.initializeBackendHttpConfigsFromInner();
        this.initializeHttpListenersFromInner();
        this.initializeRedirectConfigurationsFromInner();
        this.initializeRequestRoutingRulesFromInner();
        this.initializeSslCertificatesFromInner();
        this.initializeAuthCertificatesFromInner();
        this.initializeUrlPathMapsFromInner();
        this.defaultPrivateFrontend = null;
        this.defaultPublicFrontend = null;
        this.creatablePipsByFrontend = new HashMap<String, String>();
        this.addedRuleCollection = new AddedRuleCollection();
    }

    private void initializeAuthCertificatesFromInner() {
        this.authCertificates = new TreeMap<String, ApplicationGatewayAuthenticationCertificate>();
        List<ApplicationGatewayAuthenticationCertificateInner> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).authenticationCertificates();
        if (inners != null) {
            for (ApplicationGatewayAuthenticationCertificateInner inner : inners) {
                ApplicationGatewayAuthenticationCertificateImpl cert = new ApplicationGatewayAuthenticationCertificateImpl(inner, this);
                this.authCertificates.put(inner.name(), cert);
            }
        }
    }

    private void initializeSslCertificatesFromInner() {
        this.sslCerts = new TreeMap<String, ApplicationGatewaySslCertificate>();
        List<ApplicationGatewaySslCertificateInner> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).sslCertificates();
        if (inners != null) {
            for (ApplicationGatewaySslCertificateInner inner : inners) {
                ApplicationGatewaySslCertificateImpl cert = new ApplicationGatewaySslCertificateImpl(inner, this);
                this.sslCerts.put(inner.name(), cert);
            }
        }
    }

    private void initializeFrontendsFromInner() {
        this.frontends = new TreeMap<String, ApplicationGatewayFrontend>();
        List<ApplicationGatewayFrontendIpConfiguration> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).frontendIpConfigurations();
        if (inners != null) {
            for (ApplicationGatewayFrontendIpConfiguration inner : inners) {
                ApplicationGatewayFrontendImpl frontend = new ApplicationGatewayFrontendImpl(inner, this);
                this.frontends.put(inner.name(), frontend);
            }
        }
    }

    private void initializeProbesFromInner() {
        this.probes = new TreeMap<String, ApplicationGatewayProbe>();
        List<ApplicationGatewayProbeInner> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).probes();
        if (inners != null) {
            for (ApplicationGatewayProbeInner inner : inners) {
                ApplicationGatewayProbeImpl probe = new ApplicationGatewayProbeImpl(inner, this);
                this.probes.put(inner.name(), probe);
            }
        }
    }

    private void initializeBackendsFromInner() {
        this.backends = new TreeMap<String, ApplicationGatewayBackend>();
        List<ApplicationGatewayBackendAddressPool> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).backendAddressPools();
        if (inners != null) {
            for (ApplicationGatewayBackendAddressPool inner : inners) {
                ApplicationGatewayBackendImpl backend = new ApplicationGatewayBackendImpl(inner, this);
                this.backends.put(inner.name(), backend);
            }
        }
    }

    private void initializeBackendHttpConfigsFromInner() {
        this.backendConfigs = new TreeMap<String, ApplicationGatewayBackendHttpConfiguration>();
        List<ApplicationGatewayBackendHttpSettings> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).backendHttpSettingsCollection();
        if (inners != null) {
            for (ApplicationGatewayBackendHttpSettings inner : inners) {
                ApplicationGatewayBackendHttpConfigurationImpl httpConfig = new ApplicationGatewayBackendHttpConfigurationImpl(inner, this);
                this.backendConfigs.put(inner.name(), httpConfig);
            }
        }
    }

    private void initializeHttpListenersFromInner() {
        this.listeners = new TreeMap<String, ApplicationGatewayListener>();
        List<ApplicationGatewayHttpListener> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).httpListeners();
        if (inners != null) {
            for (ApplicationGatewayHttpListener inner : inners) {
                ApplicationGatewayListenerImpl httpListener = new ApplicationGatewayListenerImpl(inner, this);
                this.listeners.put(inner.name(), httpListener);
            }
        }
    }

    private void initializeRedirectConfigurationsFromInner() {
        this.redirectConfigs = new TreeMap<String, ApplicationGatewayRedirectConfiguration>();
        List<ApplicationGatewayRedirectConfigurationInner> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).redirectConfigurations();
        if (inners != null) {
            for (ApplicationGatewayRedirectConfigurationInner inner : inners) {
                ApplicationGatewayRedirectConfigurationImpl redirectConfig = new ApplicationGatewayRedirectConfigurationImpl(inner, this);
                this.redirectConfigs.put(inner.name(), redirectConfig);
            }
        }
    }

    private void initializeUrlPathMapsFromInner() {
        this.urlPathMaps = new TreeMap<String, ApplicationGatewayUrlPathMap>();
        List<ApplicationGatewayUrlPathMapInner> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).urlPathMaps();
        if (inners != null) {
            for (ApplicationGatewayUrlPathMapInner inner : inners) {
                ApplicationGatewayUrlPathMapImpl wrapper = new ApplicationGatewayUrlPathMapImpl(inner, this);
                this.urlPathMaps.put(inner.name(), wrapper);
            }
        }
    }

    private void initializeRequestRoutingRulesFromInner() {
        this.rules = new TreeMap<String, ApplicationGatewayRequestRoutingRule>();
        List<ApplicationGatewayRequestRoutingRuleInner> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).requestRoutingRules();
        if (inners != null) {
            for (ApplicationGatewayRequestRoutingRuleInner inner : inners) {
                ApplicationGatewayRequestRoutingRuleImpl rule = new ApplicationGatewayRequestRoutingRuleImpl(inner, this);
                this.rules.put(inner.name(), rule);
            }
        }
    }

    private void initializeConfigsFromInner() {
        this.ipConfigs = new TreeMap<String, ApplicationGatewayIpConfiguration>();
        List<ApplicationGatewayIpConfigurationInner> inners = ((ApplicationGatewayInner)((Object)this.innerModel())).gatewayIpConfigurations();
        if (inners != null) {
            for (ApplicationGatewayIpConfigurationInner inner : inners) {
                ApplicationGatewayIpConfigurationImpl config = new ApplicationGatewayIpConfigurationImpl(inner, this);
                this.ipConfigs.put(inner.name(), config);
            }
        }
    }

    public void beforeGroupCreateOrUpdate() {
        this.ensureNoMixedWaf();
    }

    protected void beforeCreating() {
        SubResource ref;
        if (this.creatableWafPolicy != null) {
            Resource resource = (Resource)this.taskResult(this.creatableWafPolicy);
            this.withExistingWebApplicationFirewallPolicy(resource.id());
        }
        this.creatableWafPolicy = null;
        for (Map.Entry<String, String> frontendPipPair : this.creatablePipsByFrontend.entrySet()) {
            Resource createdPip = (Resource)this.taskResult(frontendPipPair.getValue());
            this.updateFrontend(frontendPipPair.getKey()).withExistingPublicIpAddress(createdPip.id());
        }
        this.creatablePipsByFrontend.clear();
        this.ensureDefaultIPConfig();
        ((ApplicationGatewayInner)((Object)this.innerModel())).withGatewayIpConfigurations(this.innersFromWrappers(this.ipConfigs.values()));
        ((ApplicationGatewayInner)((Object)this.innerModel())).withFrontendIpConfigurations(this.innersFromWrappers(this.frontends.values()));
        ((ApplicationGatewayInner)((Object)this.innerModel())).withProbes(this.innersFromWrappers(this.probes.values()));
        ((ApplicationGatewayInner)((Object)this.innerModel())).withAuthenticationCertificates(this.innersFromWrappers(this.authCertificates.values()));
        ((ApplicationGatewayInner)((Object)this.innerModel())).withBackendAddressPools(this.innersFromWrappers(this.backends.values()));
        ((ApplicationGatewayInner)((Object)this.innerModel())).withSslCertificates(this.innersFromWrappers(this.sslCerts.values()));
        ((ApplicationGatewayInner)((Object)this.innerModel())).withUrlPathMaps(this.innersFromWrappers(this.urlPathMaps.values()));
        ((ApplicationGatewayInner)((Object)this.innerModel())).withBackendHttpSettingsCollection(this.innersFromWrappers(this.backendConfigs.values()));
        for (ApplicationGatewayBackendHttpConfiguration config : this.backendConfigs.values()) {
            List<SubResource> certRefs;
            ref = ((ApplicationGatewayBackendHttpSettings)((Object)config.innerModel())).probe();
            if (ref != null && !this.probes().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayBackendHttpSettings)((Object)config.innerModel())).withProbe(null);
            }
            if ((certRefs = ((ApplicationGatewayBackendHttpSettings)((Object)config.innerModel())).authenticationCertificates()) == null) continue;
            certRefs = new ArrayList<SubResource>(certRefs);
            for (SubResource certRef : certRefs) {
                if (certRef == null || this.authCertificates.containsKey(ResourceUtils.nameFromResourceId((String)certRef.id()))) continue;
                ((ApplicationGatewayBackendHttpSettings)((Object)config.innerModel())).authenticationCertificates().remove(certRef);
            }
        }
        ((ApplicationGatewayInner)((Object)this.innerModel())).withRedirectConfigurations(this.innersFromWrappers(this.redirectConfigs.values()));
        for (ApplicationGatewayRedirectConfiguration redirect : this.redirectConfigs.values()) {
            ref = ((ApplicationGatewayRedirectConfigurationInner)((Object)redirect.innerModel())).targetListener();
            if (ref == null || this.listeners.containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((ApplicationGatewayRedirectConfigurationInner)((Object)redirect.innerModel())).withTargetListener(null);
        }
        ((ApplicationGatewayInner)((Object)this.innerModel())).withHttpListeners(this.innersFromWrappers(this.listeners.values()));
        for (ApplicationGatewayListener listener : this.listeners.values()) {
            ref = ((ApplicationGatewayHttpListener)((Object)listener.innerModel())).frontendIpConfiguration();
            if (ref != null && !this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayHttpListener)((Object)listener.innerModel())).withFrontendIpConfiguration(null);
            }
            if ((ref = ((ApplicationGatewayHttpListener)((Object)listener.innerModel())).frontendPort()) != null && !this.frontendPorts().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayHttpListener)((Object)listener.innerModel())).withFrontendPort(null);
            }
            if ((ref = ((ApplicationGatewayHttpListener)((Object)listener.innerModel())).sslCertificate()) == null || this.sslCertificates().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((ApplicationGatewayHttpListener)((Object)listener.innerModel())).withSslCertificate(null);
        }
        if (this.supportsRulePriority()) {
            this.addedRuleCollection.autoAssignPriorities(this.requestRoutingRules().values(), this.name());
        }
        ((ApplicationGatewayInner)((Object)this.innerModel())).withRequestRoutingRules(this.innersFromWrappers(this.rules.values()));
        for (ApplicationGatewayRequestRoutingRule rule : this.rules.values()) {
            ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.innerModel())).redirectConfiguration();
            if (ref != null && !this.redirectConfigs.containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.innerModel())).withRedirectConfiguration(null);
            }
            if ((ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.innerModel())).backendAddressPool()) != null && !this.backends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.innerModel())).withBackendAddressPool(null);
            }
            if ((ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.innerModel())).backendHttpSettings()) != null && !this.backendConfigs.containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.innerModel())).withBackendHttpSettings(null);
            }
            if ((ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.innerModel())).httpListener()) == null || this.listeners().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.innerModel())).withHttpListener(null);
        }
    }

    protected SubResource ensureBackendRef(String name) {
        ApplicationGatewayBackendImpl backend;
        if (name == null) {
            backend = this.ensureUniqueBackend();
        } else {
            backend = this.defineBackend(name);
            backend.attach();
        }
        return new SubResource().withId(this.futureResourceId() + "/backendAddressPools/" + backend.name());
    }

    protected ApplicationGatewayBackendImpl ensureUniqueBackend() {
        String name = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("backend", 20);
        ApplicationGatewayBackendImpl backend = this.defineBackend(name);
        backend.attach();
        return backend;
    }

    private void ensureNoMixedWaf() {
        String errorMessage = "A mixture of legacy WAF configuration and WAF policy is not allowed. If you are using legacy WAF configuration, you are strongly encouraged to upgrade to WAF Policy for easier management, better scale, and a richer feature set at no additional cost. See https://learn.microsoft.com/azure/web-application-firewall/ag/upgrade-ag-waf-policy";
        if (this.creatableWafPolicy != null || ((ApplicationGatewayInner)((Object)this.innerModel())).firewallPolicy() != null) {
            if (this.isInCreateMode() ? this.legacyWafConfigurationSpecifiedInCreate : ((ApplicationGatewayInner)((Object)this.innerModel())).webApplicationFirewallConfiguration() != null) {
                throw new IllegalStateException(errorMessage);
            }
            ((ApplicationGatewayInner)((Object)this.innerModel())).withWebApplicationFirewallConfiguration(null);
        }
    }

    private ApplicationGatewayIpConfigurationImpl ensureDefaultIPConfig() {
        ApplicationGatewayIpConfigurationImpl ipConfig = (ApplicationGatewayIpConfigurationImpl)this.defaultIPConfiguration();
        if (ipConfig == null) {
            String name = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("ipcfg", 11);
            ipConfig = this.defineIPConfiguration(name);
            ipConfig.attach();
        }
        return ipConfig;
    }

    protected ApplicationGatewayFrontendImpl ensureDefaultPrivateFrontend() {
        ApplicationGatewayFrontendImpl frontend = (ApplicationGatewayFrontendImpl)this.defaultPrivateFrontend();
        if (frontend != null) {
            return frontend;
        }
        String name = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("frontend", 14);
        frontend = this.defineFrontend(name);
        frontend.attach();
        this.defaultPrivateFrontend = frontend;
        return frontend;
    }

    protected ApplicationGatewayFrontendImpl ensureDefaultPublicFrontend() {
        ApplicationGatewayFrontendImpl frontend = (ApplicationGatewayFrontendImpl)this.defaultPublicFrontend();
        if (frontend != null) {
            return frontend;
        }
        String name = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("frontend", 14);
        frontend = this.defineFrontend(name);
        frontend.attach();
        this.defaultPublicFrontend = frontend;
        return frontend;
    }

    private Creatable<Network> ensureDefaultNetworkDefinition() {
        if (this.creatableNetwork == null) {
            String vnetName = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("vnet", 10);
            this.creatableNetwork = ((Network.DefinitionStages.WithCreate)((Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)((NetworkManager)this.manager()).networks().define(vnetName)).withRegion(this.region())).withExistingResourceGroup(this.resourceGroupName())).withAddressSpace("10.0.0.0/24").withSubnet(DEFAULT, "10.0.0.0/25").withSubnet("apps", "10.0.0.128/25");
        }
        return this.creatableNetwork;
    }

    private Creatable<PublicIpAddress> ensureDefaultPipDefinition() {
        if (this.creatablePip == null) {
            String pipName = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("pip", 9);
            this.creatablePip = (Creatable)((PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)((NetworkManager)this.manager()).publicIpAddresses().define(pipName)).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
        }
        return this.creatablePip;
    }

    private static ApplicationGatewayFrontendImpl useSubnetFromIPConfigForFrontend(ApplicationGatewayIpConfigurationImpl ipConfig, ApplicationGatewayFrontendImpl frontend) {
        if (frontend != null) {
            frontend.withExistingSubnet(ipConfig.networkId(), ipConfig.subnetName());
            if (frontend.privateIpAddress() == null) {
                frontend.withPrivateIpAddressDynamic();
            } else if (frontend.privateIpAllocationMethod() == null) {
                frontend.withPrivateIpAddressDynamic();
            }
        }
        return frontend;
    }

    protected Mono<ApplicationGatewayInner> createInner() {
        Mono networkObservable;
        ApplicationGatewayFrontendImpl defaultPublicFrontend = (ApplicationGatewayFrontendImpl)this.defaultPublicFrontend();
        Mono pipObservable = defaultPublicFrontend != null && defaultPublicFrontend.publicIpAddressId() == null ? this.ensureDefaultPipDefinition().createAsync().map(publicIPAddress -> {
            defaultPublicFrontend.withExistingPublicIpAddress((PublicIpAddress)publicIPAddress);
            return publicIPAddress;
        }) : Mono.empty();
        ApplicationGatewayIpConfigurationImpl defaultIPConfig = this.ensureDefaultIPConfig();
        ApplicationGatewayFrontendImpl defaultPrivateFrontend = (ApplicationGatewayFrontendImpl)this.defaultPrivateFrontend();
        if (defaultIPConfig.subnetName() != null) {
            if (defaultPrivateFrontend != null) {
                ApplicationGatewayImpl.useSubnetFromIPConfigForFrontend(defaultIPConfig, defaultPrivateFrontend);
            }
            networkObservable = Mono.empty();
        } else {
            networkObservable = this.ensureDefaultNetworkDefinition().createAsync().map(network -> {
                defaultIPConfig.withExistingSubnet((Network)network, DEFAULT);
                if (defaultPrivateFrontend != null) {
                    ApplicationGatewayImpl.useSubnetFromIPConfigForFrontend(defaultIPConfig, defaultPrivateFrontend);
                }
                return network;
            });
        }
        ApplicationGatewaysClient innerCollection = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getApplicationGateways();
        return Flux.merge((Publisher[])new Publisher[]{networkObservable, pipObservable}).last((Object)Resource.DUMMY).flatMap(resource -> innerCollection.createOrUpdateAsync(this.resourceGroupName(), this.name(), (ApplicationGatewayInner)((Object)((Object)this.innerModel()))));
    }

    <T> CreationState needToCreate(T byName, T byPort, String name) {
        if (byName != null && byPort != null) {
            if (byName == byPort) {
                return CreationState.Found;
            }
            return CreationState.InvalidState;
        }
        if (byPort != null) {
            if (name == null) {
                return CreationState.Found;
            }
            return CreationState.InvalidState;
        }
        return CreationState.NeedToCreate;
    }

    @Override
    public ApplicationGatewayImpl withExistingWebApplicationFirewallPolicy(WebApplicationFirewallPolicy wafPolicy) {
        this.ensureWafV2();
        if (wafPolicy != null) {
            return this.withExistingWebApplicationFirewallPolicy(wafPolicy.id());
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingWebApplicationFirewallPolicy(String resourceId) {
        this.ensureWafV2();
        if (resourceId != null) {
            ((ApplicationGatewayInner)((Object)this.innerModel())).withFirewallPolicy(new SubResource().withId(resourceId));
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withNewWebApplicationFirewallPolicy(WebApplicationFirewallMode mode) {
        this.ensureWafV2();
        WebApplicationFirewallPolicy.DefinitionStages.WithCreate wafPolicyCreatable = ((WebApplicationFirewallPolicy.DefinitionStages.WithManagedRules)((WebApplicationFirewallPolicy.DefinitionStages.WithGroup)((WebApplicationFirewallPolicy.DefinitionStages.Blank)((NetworkManager)this.manager()).webApplicationFirewallPolicies().define(((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("wafpolicy", 14))).withRegion(this.region())).withExistingResourceGroup(this.resourceGroupName())).withManagedRuleSet(KnownWebApplicationGatewayManagedRuleSet.OWASP_3_2, new ManagedRuleGroupOverride[0]).withMode(mode);
        return this.withNewWebApplicationFirewallPolicy(wafPolicyCreatable);
    }

    @Override
    public ApplicationGatewayImpl withNewWebApplicationFirewallPolicy(Creatable<WebApplicationFirewallPolicy> creatable) {
        this.ensureWafV2();
        this.creatableWafPolicy = this.addDependency(creatable);
        return this;
    }

    String futureResourceId() {
        return super.resourceIdBase() + "/providers/Microsoft.Network/applicationGateways/" + this.name();
    }

    @Override
    public ApplicationGatewayImpl withDisabledSslProtocol(ApplicationGatewaySslProtocol protocol) {
        ApplicationGatewaySslPolicy policy;
        if (protocol != null && !(policy = this.ensureSslPolicy()).disabledSslProtocols().contains((Object)protocol)) {
            policy.disabledSslProtocols().add(protocol);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withDisabledSslProtocols(ApplicationGatewaySslProtocol ... protocols) {
        if (protocols != null) {
            for (ApplicationGatewaySslProtocol protocol : protocols) {
                this.withDisabledSslProtocol(protocol);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutDisabledSslProtocol(ApplicationGatewaySslProtocol protocol) {
        if (((ApplicationGatewayInner)((Object)this.innerModel())).sslPolicy() != null && ((ApplicationGatewayInner)((Object)this.innerModel())).sslPolicy().disabledSslProtocols() != null) {
            ((ApplicationGatewayInner)((Object)this.innerModel())).sslPolicy().disabledSslProtocols().remove((Object)protocol);
            if (((ApplicationGatewayInner)((Object)this.innerModel())).sslPolicy().disabledSslProtocols().isEmpty()) {
                this.withoutAnyDisabledSslProtocols();
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutDisabledSslProtocols(ApplicationGatewaySslProtocol ... protocols) {
        if (protocols != null) {
            for (ApplicationGatewaySslProtocol protocol : protocols) {
                this.withoutDisabledSslProtocol(protocol);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutAnyDisabledSslProtocols() {
        ((ApplicationGatewayInner)((Object)this.innerModel())).withSslPolicy(null);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withInstanceCount(int capacity) {
        if (((ApplicationGatewayInner)((Object)this.innerModel())).sku() == null) {
            this.withSize(ApplicationGatewaySkuName.STANDARD_SMALL);
        }
        ((ApplicationGatewayInner)((Object)this.innerModel())).sku().withCapacity(capacity);
        ((ApplicationGatewayInner)((Object)this.innerModel())).withAutoscaleConfiguration(null);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withWebApplicationFirewall(boolean enabled, ApplicationGatewayFirewallMode mode) {
        ((ApplicationGatewayInner)((Object)this.innerModel())).withWebApplicationFirewallConfiguration(new ApplicationGatewayWebApplicationFirewallConfiguration().withEnabled(enabled).withFirewallMode(mode).withRuleSetType("OWASP").withRuleSetVersion("3.0"));
        this.legacyWafConfigurationSpecifiedInCreate = true;
        return this;
    }

    @Override
    public ApplicationGatewayImpl withWebApplicationFirewall(ApplicationGatewayWebApplicationFirewallConfiguration config) {
        ((ApplicationGatewayInner)((Object)this.innerModel())).withWebApplicationFirewallConfiguration(config);
        this.legacyWafConfigurationSpecifiedInCreate = true;
        return this;
    }

    @Override
    public ApplicationGatewayImpl withAutoScale(int minCapacity, int maxCapacity) {
        ((ApplicationGatewayInner)((Object)this.innerModel())).sku().withCapacity(null);
        ((ApplicationGatewayInner)((Object)this.innerModel())).withAutoscaleConfiguration(new ApplicationGatewayAutoscaleConfiguration().withMinCapacity(minCapacity).withMaxCapacity(maxCapacity));
        return this;
    }

    @Override
    public ApplicationGatewayImpl withPrivateIpAddressDynamic() {
        this.ensureDefaultPrivateFrontend().withPrivateIpAddressDynamic();
        return this;
    }

    @Override
    public ApplicationGatewayImpl withPrivateIpAddressStatic(String ipAddress) {
        this.ensureDefaultPrivateFrontend().withPrivateIpAddressStatic(ipAddress);
        return this;
    }

    ApplicationGatewayImpl withFrontend(ApplicationGatewayFrontendImpl frontend) {
        if (frontend != null) {
            this.frontends.put(frontend.name(), frontend);
        }
        return this;
    }

    ApplicationGatewayImpl withProbe(ApplicationGatewayProbeImpl probe) {
        if (probe != null) {
            this.probes.put(probe.name(), probe);
        }
        return this;
    }

    ApplicationGatewayImpl withBackend(ApplicationGatewayBackendImpl backend) {
        if (backend != null) {
            this.backends.put(backend.name(), backend);
        }
        return this;
    }

    ApplicationGatewayImpl withAuthenticationCertificate(ApplicationGatewayAuthenticationCertificateImpl authCert) {
        if (authCert != null) {
            this.authCertificates.put(authCert.name(), authCert);
        }
        return this;
    }

    ApplicationGatewayImpl withSslCertificate(ApplicationGatewaySslCertificateImpl cert) {
        if (cert != null) {
            this.sslCerts.put(cert.name(), cert);
        }
        return this;
    }

    ApplicationGatewayImpl withHttpListener(ApplicationGatewayListenerImpl httpListener) {
        if (httpListener != null) {
            this.listeners.put(httpListener.name(), httpListener);
        }
        return this;
    }

    ApplicationGatewayImpl withRedirectConfiguration(ApplicationGatewayRedirectConfigurationImpl redirectConfig) {
        if (redirectConfig != null) {
            this.redirectConfigs.put(redirectConfig.name(), redirectConfig);
        }
        return this;
    }

    ApplicationGatewayImpl withUrlPathMap(ApplicationGatewayUrlPathMapImpl urlPathMap) {
        if (urlPathMap != null) {
            this.urlPathMaps.put(urlPathMap.name(), urlPathMap);
        }
        return this;
    }

    ApplicationGatewayImpl withRequestRoutingRule(ApplicationGatewayRequestRoutingRuleImpl rule) {
        if (rule != null) {
            this.rules.put(rule.name(), rule);
        }
        return this;
    }

    ApplicationGatewayImpl withBackendHttpConfiguration(ApplicationGatewayBackendHttpConfigurationImpl httpConfig) {
        if (httpConfig != null) {
            this.backendConfigs.put(httpConfig.name(), httpConfig);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withTier(ApplicationGatewayTier skuTier) {
        if (((ApplicationGatewayInner)((Object)this.innerModel())).sku() == null) {
            ((ApplicationGatewayInner)((Object)this.innerModel())).withSku(new ApplicationGatewaySku().withCapacity(1));
        }
        ((ApplicationGatewayInner)((Object)this.innerModel())).sku().withTier(skuTier);
        if (skuTier == ApplicationGatewayTier.WAF_V2 && ((ApplicationGatewayInner)((Object)this.innerModel())).webApplicationFirewallConfiguration() == null) {
            ((ApplicationGatewayInner)((Object)this.innerModel())).withWebApplicationFirewallConfiguration(new ApplicationGatewayWebApplicationFirewallConfiguration().withEnabled(true).withFirewallMode(ApplicationGatewayFirewallMode.DETECTION).withRuleSetType("OWASP").withRuleSetVersion("3.0"));
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withSize(ApplicationGatewaySkuName skuName) {
        if (((ApplicationGatewayInner)((Object)this.innerModel())).sku() == null) {
            ((ApplicationGatewayInner)((Object)this.innerModel())).withSku(new ApplicationGatewaySku().withCapacity(1));
        }
        ((ApplicationGatewayInner)((Object)this.innerModel())).sku().withName(skuName);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingSubnet(Subnet subnet) {
        this.ensureDefaultIPConfig().withExistingSubnet(subnet);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingSubnet(Network network, String subnetName) {
        this.ensureDefaultIPConfig().withExistingSubnet(network, subnetName);
        return this;
    }

    public ApplicationGatewayImpl withExistingSubnet(String networkResourceId, String subnetName) {
        this.ensureDefaultIPConfig().withExistingSubnet(networkResourceId, subnetName);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withIdentity(ManagedServiceIdentity identity) {
        ((ApplicationGatewayInner)((Object)this.innerModel())).withIdentity(identity);
        return this;
    }

    ApplicationGatewayImpl withConfig(ApplicationGatewayIpConfigurationImpl config) {
        if (config != null) {
            this.ipConfigs.put(config.name(), config);
        }
        return this;
    }

    public ApplicationGatewaySslCertificateImpl defineSslCertificate(String name) {
        return this.defineChild(name, this.sslCerts, ApplicationGatewaySslCertificateInner.class, ApplicationGatewaySslCertificateImpl.class);
    }

    private ApplicationGatewayIpConfigurationImpl defineIPConfiguration(String name) {
        return this.defineChild(name, this.ipConfigs, ApplicationGatewayIpConfigurationInner.class, ApplicationGatewayIpConfigurationImpl.class);
    }

    private ApplicationGatewayFrontendImpl defineFrontend(String name) {
        return this.defineChild(name, this.frontends, ApplicationGatewayFrontendIpConfiguration.class, ApplicationGatewayFrontendImpl.class);
    }

    public ApplicationGatewayRedirectConfigurationImpl defineRedirectConfiguration(String name) {
        return this.defineChild(name, this.redirectConfigs, ApplicationGatewayRedirectConfigurationInner.class, ApplicationGatewayRedirectConfigurationImpl.class);
    }

    public ApplicationGatewayRequestRoutingRuleImpl defineRequestRoutingRule(String name) {
        ApplicationGatewayRequestRoutingRuleImpl rule = this.defineChild(name, this.rules, ApplicationGatewayRequestRoutingRuleInner.class, ApplicationGatewayRequestRoutingRuleImpl.class);
        this.addedRuleCollection.addRule(rule);
        return rule;
    }

    public ApplicationGatewayBackendImpl defineBackend(String name) {
        return this.defineChild(name, this.backends, ApplicationGatewayBackendAddressPool.class, ApplicationGatewayBackendImpl.class);
    }

    public ApplicationGatewayAuthenticationCertificateImpl defineAuthenticationCertificate(String name) {
        return this.defineChild(name, this.authCertificates, ApplicationGatewayAuthenticationCertificateInner.class, ApplicationGatewayAuthenticationCertificateImpl.class);
    }

    public ApplicationGatewayProbeImpl defineProbe(String name) {
        return this.defineChild(name, this.probes, ApplicationGatewayProbeInner.class, ApplicationGatewayProbeImpl.class);
    }

    public ApplicationGatewayUrlPathMapImpl definePathBasedRoutingRule(String name) {
        ApplicationGatewayUrlPathMapImpl urlPathMap = this.defineChild(name, this.urlPathMaps, ApplicationGatewayUrlPathMapInner.class, ApplicationGatewayUrlPathMapImpl.class);
        SubResource ref = new SubResource().withId(this.futureResourceId() + "/urlPathMaps/" + name);
        ApplicationGatewayRequestRoutingRuleInner inner = new ApplicationGatewayRequestRoutingRuleInner().withName(name).withRuleType(ApplicationGatewayRequestRoutingRuleType.PATH_BASED_ROUTING).withUrlPathMap(ref);
        ApplicationGatewayRequestRoutingRuleImpl requestRoutingRule = new ApplicationGatewayRequestRoutingRuleImpl(inner, this);
        this.rules.put(name, requestRoutingRule);
        this.addedRuleCollection.addRule(requestRoutingRule);
        return urlPathMap;
    }

    public ApplicationGatewayListenerImpl defineListener(String name) {
        return this.defineChild(name, this.listeners, ApplicationGatewayHttpListener.class, ApplicationGatewayListenerImpl.class);
    }

    public ApplicationGatewayBackendHttpConfigurationImpl defineBackendHttpConfiguration(String name) {
        ApplicationGatewayBackendHttpConfigurationImpl config = this.defineChild(name, this.backendConfigs, ApplicationGatewayBackendHttpSettings.class, ApplicationGatewayBackendHttpConfigurationImpl.class);
        if (((ApplicationGatewayBackendHttpSettings)((Object)config.innerModel())).id() == null) {
            return config.withPort(80);
        }
        return config;
    }

    private <ChildImplT, ChildT, ChildInnerT> ChildImplT defineChild(String name, Map<String, ChildT> children, Class<ChildInnerT> innerClass, Class<ChildImplT> implClass) {
        ChildT child = children.get(name);
        if (child == null) {
            try {
                ChildInnerT inner = innerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                innerClass.getDeclaredMethod("withName", String.class).invoke(inner, name);
                return implClass.getDeclaredConstructor(innerClass, ApplicationGatewayImpl.class).newInstance(inner, this);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                return null;
            }
        }
        return (ChildImplT)child;
    }

    @Override
    public ApplicationGatewayImpl withoutPrivateFrontend() {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPrivate()) continue;
            toDelete.add(frontend.name());
        }
        for (String frontendName : toDelete) {
            this.frontends.remove(frontendName);
        }
        this.defaultPrivateFrontend = null;
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutPublicFrontend() {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPublic()) continue;
            toDelete.add(frontend.name());
        }
        for (String frontendName : toDelete) {
            this.frontends.remove(frontendName);
        }
        this.defaultPublicFrontend = null;
        return this;
    }

    @Override
    public ApplicationGatewayImpl withFrontendPort(int portNumber) {
        return this.withFrontendPort(portNumber, null);
    }

    @Override
    public ApplicationGatewayImpl withFrontendPort(int portNumber, String name) {
        List<ApplicationGatewayFrontendPort> frontendPorts = ((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts();
        if (frontendPorts == null) {
            frontendPorts = new ArrayList<ApplicationGatewayFrontendPort>();
            ((ApplicationGatewayInner)((Object)this.innerModel())).withFrontendPorts(frontendPorts);
        }
        ApplicationGatewayFrontendPort frontendPortByName = null;
        ApplicationGatewayFrontendPort frontendPortByNumber = null;
        for (ApplicationGatewayFrontendPort inner : ((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts()) {
            if (name != null && name.equalsIgnoreCase(inner.name())) {
                frontendPortByName = inner;
            }
            if (inner.port() != portNumber) continue;
            frontendPortByNumber = inner;
        }
        CreationState needToCreate = this.needToCreate(frontendPortByName, frontendPortByNumber, name);
        if (needToCreate == CreationState.NeedToCreate) {
            if (name == null) {
                name = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("port", 9);
            }
            frontendPortByName = new ApplicationGatewayFrontendPort().withName(name).withPort(portNumber);
            frontendPorts.add(frontendPortByName);
            return this;
        }
        if (needToCreate == CreationState.Found) {
            return this;
        }
        return null;
    }

    @Override
    public ApplicationGatewayImpl withPrivateFrontend() {
        this.ensureDefaultPrivateFrontend();
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingPublicIpAddress(PublicIpAddress publicIPAddress) {
        this.ensureDefaultPublicFrontend().withExistingPublicIpAddress(publicIPAddress);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingPublicIpAddress(String resourceId) {
        this.ensureDefaultPublicFrontend().withExistingPublicIpAddress(resourceId);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withNewPublicIpAddress(Creatable<PublicIpAddress> creatable) {
        String name = this.ensureDefaultPublicFrontend().name();
        this.creatablePipsByFrontend.put(name, this.addDependency(creatable));
        return this;
    }

    @Override
    public ApplicationGatewayImpl withNewPublicIpAddress() {
        this.ensureDefaultPublicFrontend();
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutBackendFqdn(String fqdn) {
        for (ApplicationGatewayBackend backend : this.backends.values()) {
            ((ApplicationGatewayBackendImpl)backend).withoutFqdn(fqdn);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutBackendIPAddress(String ipAddress) {
        for (ApplicationGatewayBackend backend : this.backends.values()) {
            ApplicationGatewayBackendImpl backendImpl = (ApplicationGatewayBackendImpl)backend;
            backendImpl.withoutIPAddress(ipAddress);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutIPConfiguration(String ipConfigurationName) {
        this.ipConfigs.remove(ipConfigurationName);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutFrontend(String frontendName) {
        this.frontends.remove(frontendName);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutFrontendPort(String name) {
        if (((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts() == null) {
            return this;
        }
        for (int i = 0; i < ((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts().size(); ++i) {
            ApplicationGatewayFrontendPort inner = ((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts().get(i);
            if (!inner.name().equalsIgnoreCase(name)) continue;
            ((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts().remove(i);
            break;
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutFrontendPort(int portNumber) {
        for (int i = 0; i < ((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts().size(); ++i) {
            ApplicationGatewayFrontendPort inner = ((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts().get(i);
            if (!inner.port().equals(portNumber)) continue;
            ((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts().remove(i);
            break;
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutSslCertificate(String name) {
        this.sslCerts.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutAuthenticationCertificate(String name) {
        this.authCertificates.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutProbe(String name) {
        this.probes.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutListener(String name) {
        this.listeners.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutRedirectConfiguration(String name) {
        this.redirectConfigs.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutUrlPathMap(String name) {
        for (ApplicationGatewayRequestRoutingRule rule : this.rules.values()) {
            if (rule.urlPathMap() == null || !name.equals(rule.urlPathMap().name())) continue;
            this.rules.remove(rule.name());
            break;
        }
        this.urlPathMaps.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutRequestRoutingRule(String name) {
        this.rules.remove(name);
        this.addedRuleCollection.removeRule(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutBackend(String backendName) {
        this.backends.remove(backendName);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withHttp2() {
        ((ApplicationGatewayInner)((Object)this.innerModel())).withEnableHttp2(true);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutHttp2() {
        ((ApplicationGatewayInner)((Object)this.innerModel())).withEnableHttp2(false);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((ApplicationGatewayInner)((Object)this.innerModel())).zones() == null) {
            ((ApplicationGatewayInner)((Object)this.innerModel())).withZones(new ArrayList<String>());
        }
        if (!((ApplicationGatewayInner)((Object)this.innerModel())).zones().contains(zoneId.toString())) {
            ((ApplicationGatewayInner)((Object)this.innerModel())).zones().add(zoneId.toString());
        }
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl updateBackend(String name) {
        return (ApplicationGatewayBackendImpl)this.backends.get(name);
    }

    @Override
    public ApplicationGatewayFrontendImpl updatePublicFrontend() {
        return (ApplicationGatewayFrontendImpl)this.defaultPublicFrontend();
    }

    @Override
    public ApplicationGatewayListenerImpl updateListener(String name) {
        return (ApplicationGatewayListenerImpl)this.listeners.get(name);
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl updateRedirectConfiguration(String name) {
        return (ApplicationGatewayRedirectConfigurationImpl)this.redirectConfigs.get(name);
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl updateRequestRoutingRule(String name) {
        return (ApplicationGatewayRequestRoutingRuleImpl)this.rules.get(name);
    }

    @Override
    public ApplicationGatewayImpl withoutBackendHttpConfiguration(String name) {
        this.backendConfigs.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl updateBackendHttpConfiguration(String name) {
        return (ApplicationGatewayBackendHttpConfigurationImpl)this.backendConfigs.get(name);
    }

    @Override
    public ApplicationGatewayIpConfigurationImpl updateIPConfiguration(String ipConfigurationName) {
        return (ApplicationGatewayIpConfigurationImpl)this.ipConfigs.get(ipConfigurationName);
    }

    @Override
    public ApplicationGatewayProbeImpl updateProbe(String name) {
        return (ApplicationGatewayProbeImpl)this.probes.get(name);
    }

    @Override
    public ApplicationGatewayIpConfigurationImpl updateDefaultIPConfiguration() {
        return (ApplicationGatewayIpConfigurationImpl)this.defaultIPConfiguration();
    }

    public ApplicationGatewayIpConfigurationImpl defineDefaultIPConfiguration() {
        return this.ensureDefaultIPConfig();
    }

    public ApplicationGatewayFrontendImpl definePublicFrontend() {
        return this.ensureDefaultPublicFrontend();
    }

    public ApplicationGatewayFrontendImpl definePrivateFrontend() {
        return this.ensureDefaultPrivateFrontend();
    }

    @Override
    public ApplicationGatewayFrontendImpl updateFrontend(String frontendName) {
        return (ApplicationGatewayFrontendImpl)this.frontends.get(frontendName);
    }

    @Override
    public ApplicationGatewayUrlPathMapImpl updateUrlPathMap(String name) {
        return (ApplicationGatewayUrlPathMapImpl)this.urlPathMaps.get(name);
    }

    @Override
    public Collection<ApplicationGatewaySslProtocol> disabledSslProtocols() {
        if (((ApplicationGatewayInner)((Object)this.innerModel())).sslPolicy() == null || ((ApplicationGatewayInner)((Object)this.innerModel())).sslPolicy().disabledSslProtocols() == null) {
            return new ArrayList<ApplicationGatewaySslProtocol>();
        }
        return Collections.unmodifiableCollection(((ApplicationGatewayInner)((Object)this.innerModel())).sslPolicy().disabledSslProtocols());
    }

    @Override
    public ApplicationGatewayFrontend defaultPrivateFrontend() {
        Map<String, ApplicationGatewayFrontend> privateFrontends = this.privateFrontends();
        if (privateFrontends.size() == 1) {
            this.defaultPrivateFrontend = (ApplicationGatewayFrontendImpl)privateFrontends.values().iterator().next();
        } else if (this.frontends().size() == 0) {
            this.defaultPrivateFrontend = null;
        }
        return this.defaultPrivateFrontend;
    }

    @Override
    public ApplicationGatewayFrontend defaultPublicFrontend() {
        Map<String, ApplicationGatewayFrontend> publicFrontends = this.publicFrontends();
        if (publicFrontends.size() == 1) {
            this.defaultPublicFrontend = (ApplicationGatewayFrontendImpl)publicFrontends.values().iterator().next();
        } else if (this.frontends().size() == 0) {
            this.defaultPublicFrontend = null;
        }
        return this.defaultPublicFrontend;
    }

    @Override
    public ApplicationGatewayIpConfiguration defaultIPConfiguration() {
        if (this.ipConfigs.size() == 1) {
            return this.ipConfigs.values().iterator().next();
        }
        return null;
    }

    @Override
    public ApplicationGatewayListener listenerByPortNumber(int portNumber) {
        ApplicationGatewayListener listener = null;
        for (ApplicationGatewayListener l : this.listeners.values()) {
            if (l.frontendPortNumber() != portNumber) continue;
            listener = l;
            break;
        }
        return listener;
    }

    @Override
    public String getWebApplicationFirewallPolicyId() {
        if (((ApplicationGatewayInner)((Object)this.innerModel())).firewallPolicy() == null) {
            return null;
        }
        return ((ApplicationGatewayInner)((Object)this.innerModel())).firewallPolicy().id();
    }

    @Override
    public WebApplicationFirewallPolicy getWebApplicationFirewallPolicy() {
        return (WebApplicationFirewallPolicy)this.getWebApplicationFirewallPolicyAsync().block();
    }

    @Override
    public Mono<WebApplicationFirewallPolicy> getWebApplicationFirewallPolicyAsync() {
        if (this.getWebApplicationFirewallPolicyId() == null) {
            return Mono.empty();
        }
        return ((NetworkManager)this.manager()).webApplicationFirewallPolicies().getByIdAsync(((ApplicationGatewayInner)((Object)this.innerModel())).firewallPolicy().id());
    }

    @Override
    public Map<String, ApplicationGatewayAuthenticationCertificate> authenticationCertificates() {
        return Collections.unmodifiableMap(this.authCertificates);
    }

    @Override
    public boolean isHttp2Enabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ApplicationGatewayInner)((Object)this.innerModel())).enableHttp2());
    }

    @Override
    public Map<String, ApplicationGatewayUrlPathMap> urlPathMaps() {
        return Collections.unmodifiableMap(this.urlPathMaps);
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        TreeSet<AvailabilityZoneId> zones = new TreeSet<AvailabilityZoneId>();
        if (((ApplicationGatewayInner)((Object)this.innerModel())).zones() != null) {
            for (String zone : ((ApplicationGatewayInner)((Object)this.innerModel())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public Map<String, ApplicationGatewayBackendHttpConfiguration> backendHttpConfigurations() {
        return Collections.unmodifiableMap(this.backendConfigs);
    }

    @Override
    public Map<String, ApplicationGatewayBackend> backends() {
        return Collections.unmodifiableMap(this.backends);
    }

    @Override
    public Map<String, ApplicationGatewayRequestRoutingRule> requestRoutingRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public Map<String, ApplicationGatewayFrontend> frontends() {
        return Collections.unmodifiableMap(this.frontends);
    }

    @Override
    public Map<String, ApplicationGatewayProbe> probes() {
        return Collections.unmodifiableMap(this.probes);
    }

    @Override
    public Map<String, ApplicationGatewaySslCertificate> sslCertificates() {
        return Collections.unmodifiableMap(this.sslCerts);
    }

    @Override
    public Map<String, ApplicationGatewayListener> listeners() {
        return Collections.unmodifiableMap(this.listeners);
    }

    @Override
    public Map<String, ApplicationGatewayRedirectConfiguration> redirectConfigurations() {
        return Collections.unmodifiableMap(this.redirectConfigs);
    }

    @Override
    public Map<String, ApplicationGatewayIpConfiguration> ipConfigurations() {
        return Collections.unmodifiableMap(this.ipConfigs);
    }

    @Override
    public ApplicationGatewaySku sku() {
        return ((ApplicationGatewayInner)((Object)this.innerModel())).sku();
    }

    @Override
    public ApplicationGatewayOperationalState operationalState() {
        return ((ApplicationGatewayInner)((Object)this.innerModel())).operationalState();
    }

    @Override
    public Map<String, Integer> frontendPorts() {
        TreeMap<String, Integer> ports = new TreeMap<String, Integer>();
        if (((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts() != null) {
            for (ApplicationGatewayFrontendPort portInner : ((ApplicationGatewayInner)((Object)this.innerModel())).frontendPorts()) {
                ports.put(portInner.name(), portInner.port());
            }
        }
        return Collections.unmodifiableMap(ports);
    }

    @Override
    public String frontendPortNameFromNumber(int portNumber) {
        String portName = null;
        for (Map.Entry<String, Integer> portEntry : this.frontendPorts().entrySet()) {
            if (portNumber != portEntry.getValue()) continue;
            portName = portEntry.getKey();
            break;
        }
        return portName;
    }

    private SubResource defaultSubnetRef() {
        ApplicationGatewayIpConfiguration ipConfig = this.defaultIPConfiguration();
        if (ipConfig == null) {
            return null;
        }
        return ((ApplicationGatewayIpConfigurationInner)((Object)ipConfig.innerModel())).subnet();
    }

    public String networkId() {
        SubResource subnetRef = this.defaultSubnetRef();
        if (subnetRef == null) {
            return null;
        }
        return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
    }

    public String subnetName() {
        SubResource subnetRef = this.defaultSubnetRef();
        if (subnetRef == null) {
            return null;
        }
        return ResourceUtils.nameFromResourceId((String)subnetRef.id());
    }

    @Override
    public String privateIpAddress() {
        ApplicationGatewayFrontend frontend = this.defaultPrivateFrontend();
        if (frontend == null) {
            return null;
        }
        return frontend.privateIpAddress();
    }

    @Override
    public IpAllocationMethod privateIpAllocationMethod() {
        ApplicationGatewayFrontend frontend = this.defaultPrivateFrontend();
        if (frontend == null) {
            return null;
        }
        return frontend.privateIpAllocationMethod();
    }

    @Override
    public boolean isPrivate() {
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPrivate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPublic() {
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPublic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, ApplicationGatewayFrontend> publicFrontends() {
        TreeMap<String, ApplicationGatewayFrontend> publicFrontends = new TreeMap<String, ApplicationGatewayFrontend>();
        for (ApplicationGatewayFrontend frontend : this.frontends().values()) {
            if (!frontend.isPublic()) continue;
            publicFrontends.put(frontend.name(), frontend);
        }
        return Collections.unmodifiableMap(publicFrontends);
    }

    @Override
    public Map<String, ApplicationGatewayFrontend> privateFrontends() {
        TreeMap<String, ApplicationGatewayFrontend> privateFrontends = new TreeMap<String, ApplicationGatewayFrontend>();
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPrivate()) continue;
            privateFrontends.put(frontend.name(), frontend);
        }
        return Collections.unmodifiableMap(privateFrontends);
    }

    @Override
    public int instanceCount() {
        if (this.sku() != null && this.sku().capacity() != null) {
            return this.sku().capacity();
        }
        return 1;
    }

    @Override
    public ApplicationGatewaySkuName size() {
        if (this.sku() != null && this.sku().name() != null) {
            return this.sku().name();
        }
        return ApplicationGatewaySkuName.STANDARD_SMALL;
    }

    @Override
    public ApplicationGatewayTier tier() {
        if (this.sku() != null && this.sku().tier() != null) {
            return this.sku().tier();
        }
        return ApplicationGatewayTier.STANDARD;
    }

    @Override
    public ApplicationGatewayAutoscaleConfiguration autoscaleConfiguration() {
        return ((ApplicationGatewayInner)((Object)this.innerModel())).autoscaleConfiguration();
    }

    @Override
    public ApplicationGatewayWebApplicationFirewallConfiguration webApplicationFirewallConfiguration() {
        return ((ApplicationGatewayInner)((Object)this.innerModel())).webApplicationFirewallConfiguration();
    }

    @Override
    public ApplicationGateway.Update withoutPublicIpAddress() {
        return this.withoutPublicFrontend();
    }

    @Override
    public void start() {
        this.startAsync().block();
    }

    @Override
    public void stop() {
        this.stopAsync().block();
    }

    @Override
    public Mono<Void> startAsync() {
        Mono<Void> startObservable = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getApplicationGateways().startAsync(this.resourceGroupName(), this.name());
        Mono<ApplicationGateway> refreshObservable = this.refreshAsync();
        return Flux.concat((Publisher[])new Publisher[]{startObservable, refreshObservable}).then();
    }

    @Override
    public Mono<Void> stopAsync() {
        Mono<Void> stopObservable = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getApplicationGateways().stopAsync(this.resourceGroupName(), this.name());
        Mono<ApplicationGateway> refreshObservable = this.refreshAsync();
        return Flux.concat((Publisher[])new Publisher[]{stopObservable, refreshObservable}).then();
    }

    private ApplicationGatewaySslPolicy ensureSslPolicy() {
        List<ApplicationGatewaySslProtocol> protocols;
        ApplicationGatewaySslPolicy policy = ((ApplicationGatewayInner)((Object)this.innerModel())).sslPolicy();
        if (policy == null) {
            policy = new ApplicationGatewaySslPolicy();
            ((ApplicationGatewayInner)((Object)this.innerModel())).withSslPolicy(policy);
        }
        if ((protocols = policy.disabledSslProtocols()) == null) {
            protocols = new ArrayList<ApplicationGatewaySslProtocol>();
            policy.withDisabledSslProtocols(protocols);
        }
        return policy;
    }

    @Override
    public Map<String, ApplicationGatewayBackendHealth> checkBackendHealth() {
        return (Map)this.checkBackendHealthAsync().block();
    }

    @Override
    public Mono<Map<String, ApplicationGatewayBackendHealth>> checkBackendHealthAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getApplicationGateways().backendHealthAsync(this.resourceGroupName(), this.name(), null).map(inner -> {
            TreeMap<String, ApplicationGatewayBackendHealthImpl> backendHealths = new TreeMap<String, ApplicationGatewayBackendHealthImpl>();
            if (inner != null) {
                for (ApplicationGatewayBackendHealthPool healthInner : inner.backendAddressPools()) {
                    ApplicationGatewayBackendHealthImpl backendHealth = new ApplicationGatewayBackendHealthImpl(healthInner, this);
                    backendHealths.put(backendHealth.name(), backendHealth);
                }
            }
            return Collections.unmodifiableMap(backendHealths);
        });
    }

    private boolean supportsRulePriority() {
        ApplicationGatewayTier tier = this.tier();
        ApplicationGatewaySkuName sku = this.size();
        return tier != ApplicationGatewayTier.STANDARD && sku != ApplicationGatewaySkuName.STANDARD_SMALL && sku != ApplicationGatewaySkuName.STANDARD_MEDIUM && sku != ApplicationGatewaySkuName.STANDARD_LARGE && sku != ApplicationGatewaySkuName.WAF_MEDIUM && sku != ApplicationGatewaySkuName.WAF_LARGE;
    }

    private void ensureWafV2() {
        if (this.tier() != ApplicationGatewayTier.WAF_V2) {
            throw new IllegalStateException("WAF policy can only be used with WAF_V2 tier");
        }
    }

    private static class AddedRuleCollection {
        private static final int AUTO_ASSIGN_PRIORITY_START = 10010;
        private static final int MAX_PRIORITY = 20000;
        private static final int PRIORITY_INTERVAL = 10;
        private final Map<String, ApplicationGatewayRequestRoutingRuleImpl> ruleMap = new LinkedHashMap<String, ApplicationGatewayRequestRoutingRuleImpl>();

        private AddedRuleCollection() {
        }

        void removeRule(String name) {
            this.ruleMap.remove(name);
        }

        void addRule(ApplicationGatewayRequestRoutingRuleImpl rule) {
            this.ruleMap.put(rule.name(), rule);
        }

        void autoAssignPriorities(Collection<ApplicationGatewayRequestRoutingRule> existingRules, String gatewayName) {
            Set existingPriorities = existingRules.stream().map(ApplicationGatewayRequestRoutingRule::priority).filter(Objects::nonNull).collect(Collectors.toSet());
            int nextPriorityToAssign = 10010;
            for (ApplicationGatewayRequestRoutingRuleImpl rule : this.ruleMap.values()) {
                if (rule.priority() != null) continue;
                boolean assigned = false;
                for (int priority = nextPriorityToAssign; priority <= 20000; priority += 10) {
                    if (existingPriorities.contains(priority)) continue;
                    rule.withPriority(priority);
                    assigned = true;
                    existingPriorities.add(priority);
                    nextPriorityToAssign = priority + 10;
                    break;
                }
                if (assigned) continue;
                throw new IllegalStateException(String.format("Failed to auto assign priority for rule: %s, gateway: %s", rule.name(), gatewayName));
            }
        }
    }

    static enum CreationState {
        Found,
        NeedToCreate,
        InvalidState;

    }
}

