/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.VirtualNetworkGatewayNatRulesClient;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayNatRuleInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ListVirtualNetworkGatewayNatRulesResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VirtualNetworkGatewayNatRulesClientImpl
implements VirtualNetworkGatewayNatRulesClient {
    private final VirtualNetworkGatewayNatRulesService service;
    private final NetworkManagementClientImpl client;

    VirtualNetworkGatewayNatRulesClientImpl(NetworkManagementClientImpl client) {
        this.service = (VirtualNetworkGatewayNatRulesService)RestProxy.create(VirtualNetworkGatewayNatRulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualNetworkGatewayNatRuleInner>> getWithResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        String apiVersion = "2023-02-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkGatewayName, natRuleName, "2023-02-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualNetworkGatewayNatRuleInner>> getWithResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        String apiVersion = "2023-02-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkGatewayName, natRuleName, "2023-02-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualNetworkGatewayNatRuleInner> getAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        return this.getWithResponseAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VirtualNetworkGatewayNatRuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualNetworkGatewayNatRuleInner> getWithResponse(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkGatewayNatRuleInner get(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        return (VirtualNetworkGatewayNatRuleInner)((Object)this.getWithResponse(resourceGroupName, virtualNetworkGatewayName, natRuleName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, VirtualNetworkGatewayNatRuleInner natRuleParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        if (natRuleParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter natRuleParameters is required and cannot be null."));
        }
        natRuleParameters.validate();
        String apiVersion = "2023-02-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkGatewayName, natRuleName, "2023-02-01", natRuleParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, VirtualNetworkGatewayNatRuleInner natRuleParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        if (natRuleParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter natRuleParameters is required and cannot be null."));
        }
        natRuleParameters.validate();
        String apiVersion = "2023-02-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkGatewayName, natRuleName, "2023-02-01", natRuleParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualNetworkGatewayNatRuleInner>, VirtualNetworkGatewayNatRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, VirtualNetworkGatewayNatRuleInner natRuleParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualNetworkGatewayNatRuleInner.class), (Type)((Object)VirtualNetworkGatewayNatRuleInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualNetworkGatewayNatRuleInner>, VirtualNetworkGatewayNatRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, VirtualNetworkGatewayNatRuleInner natRuleParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualNetworkGatewayNatRuleInner.class), (Type)((Object)VirtualNetworkGatewayNatRuleInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualNetworkGatewayNatRuleInner>, VirtualNetworkGatewayNatRuleInner> beginCreateOrUpdate(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, VirtualNetworkGatewayNatRuleInner natRuleParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualNetworkGatewayNatRuleInner>, VirtualNetworkGatewayNatRuleInner> beginCreateOrUpdate(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, VirtualNetworkGatewayNatRuleInner natRuleParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualNetworkGatewayNatRuleInner> createOrUpdateAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, VirtualNetworkGatewayNatRuleInner natRuleParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualNetworkGatewayNatRuleInner> createOrUpdateAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, VirtualNetworkGatewayNatRuleInner natRuleParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkGatewayNatRuleInner createOrUpdate(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, VirtualNetworkGatewayNatRuleInner natRuleParameters) {
        return (VirtualNetworkGatewayNatRuleInner)((Object)this.createOrUpdateAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkGatewayNatRuleInner createOrUpdate(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, VirtualNetworkGatewayNatRuleInner natRuleParameters, Context context) {
        return (VirtualNetworkGatewayNatRuleInner)((Object)this.createOrUpdateAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, natRuleParameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        String apiVersion = "2023-02-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkGatewayName, natRuleName, "2023-02-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        if (natRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter natRuleName is required and cannot be null."));
        }
        String apiVersion = "2023-02-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkGatewayName, natRuleName, "2023-02-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        return this.beginDeleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        return this.beginDeleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName) {
        this.deleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualNetworkGatewayName, String natRuleName, Context context) {
        this.deleteAsync(resourceGroupName, virtualNetworkGatewayName, natRuleName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkGatewayNatRuleInner>> listByVirtualNetworkGatewaySinglePageAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        String apiVersion = "2023-02-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualNetworkGateway(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkGatewayName, "2023-02-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListVirtualNetworkGatewayNatRulesResult)res.getValue()).value(), ((ListVirtualNetworkGatewayNatRulesResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkGatewayNatRuleInner>> listByVirtualNetworkGatewaySinglePageAsync(String resourceGroupName, String virtualNetworkGatewayName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualNetworkGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null."));
        }
        String apiVersion = "2023-02-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByVirtualNetworkGateway(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkGatewayName, "2023-02-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListVirtualNetworkGatewayNatRulesResult)res.getValue()).value(), ((ListVirtualNetworkGatewayNatRulesResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualNetworkGatewayNatRuleInner> listByVirtualNetworkGatewayAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return new PagedFlux(() -> this.listByVirtualNetworkGatewaySinglePageAsync(resourceGroupName, virtualNetworkGatewayName), nextLink -> this.listByVirtualNetworkGatewayNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualNetworkGatewayNatRuleInner> listByVirtualNetworkGatewayAsync(String resourceGroupName, String virtualNetworkGatewayName, Context context) {
        return new PagedFlux(() -> this.listByVirtualNetworkGatewaySinglePageAsync(resourceGroupName, virtualNetworkGatewayName, context), nextLink -> this.listByVirtualNetworkGatewayNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkGatewayNatRuleInner> listByVirtualNetworkGateway(String resourceGroupName, String virtualNetworkGatewayName) {
        return new PagedIterable(this.listByVirtualNetworkGatewayAsync(resourceGroupName, virtualNetworkGatewayName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkGatewayNatRuleInner> listByVirtualNetworkGateway(String resourceGroupName, String virtualNetworkGatewayName, Context context) {
        return new PagedIterable(this.listByVirtualNetworkGatewayAsync(resourceGroupName, virtualNetworkGatewayName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkGatewayNatRuleInner>> listByVirtualNetworkGatewayNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualNetworkGatewayNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListVirtualNetworkGatewayNatRulesResult)res.getValue()).value(), ((ListVirtualNetworkGatewayNatRulesResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkGatewayNatRuleInner>> listByVirtualNetworkGatewayNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByVirtualNetworkGatewayNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListVirtualNetworkGatewayNatRulesResult)res.getValue()).value(), ((ListVirtualNetworkGatewayNatRulesResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface VirtualNetworkGatewayNatRulesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/natRules/{natRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkGatewayNatRuleInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualNetworkGatewayName") String var4, @PathParam(value="natRuleName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/natRules/{natRuleName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualNetworkGatewayName") String var4, @PathParam(value="natRuleName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") VirtualNetworkGatewayNatRuleInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/natRules/{natRuleName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualNetworkGatewayName") String var4, @PathParam(value="natRuleName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/natRules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListVirtualNetworkGatewayNatRulesResult>> listByVirtualNetworkGateway(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualNetworkGatewayName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListVirtualNetworkGatewayNatRulesResult>> listByVirtualNetworkGatewayNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

