// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewaySslPredefinedPolicyInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response for ApplicationGatewayAvailableSslOptions API service call. */
@Fluent
public final class ApplicationGatewayAvailableSslPredefinedPolicies {
    /*
     * List of available Ssl predefined policy.
     */
    @JsonProperty(value = "value")
    private List<ApplicationGatewaySslPredefinedPolicyInner> value;

    /*
     * URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of ApplicationGatewayAvailableSslPredefinedPolicies class. */
    public ApplicationGatewayAvailableSslPredefinedPolicies() {
    }

    /**
     * Get the value property: List of available Ssl predefined policy.
     *
     * @return the value value.
     */
    public List<ApplicationGatewaySslPredefinedPolicyInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of available Ssl predefined policy.
     *
     * @param value the value value to set.
     * @return the ApplicationGatewayAvailableSslPredefinedPolicies object itself.
     */
    public ApplicationGatewayAvailableSslPredefinedPolicies withValue(
        List<ApplicationGatewaySslPredefinedPolicyInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the ApplicationGatewayAvailableSslPredefinedPolicies object itself.
     */
    public ApplicationGatewayAvailableSslPredefinedPolicies withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
