// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic. */
public final class SecurityConfigurationRuleDirection extends ExpandableStringEnum<SecurityConfigurationRuleDirection> {
    /** Static value Inbound for SecurityConfigurationRuleDirection. */
    public static final SecurityConfigurationRuleDirection INBOUND = fromString("Inbound");

    /** Static value Outbound for SecurityConfigurationRuleDirection. */
    public static final SecurityConfigurationRuleDirection OUTBOUND = fromString("Outbound");

    /**
     * Creates a new instance of SecurityConfigurationRuleDirection value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SecurityConfigurationRuleDirection() {
    }

    /**
     * Creates or finds a SecurityConfigurationRuleDirection from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SecurityConfigurationRuleDirection.
     */
    @JsonCreator
    public static SecurityConfigurationRuleDirection fromString(String name) {
        return fromString(name, SecurityConfigurationRuleDirection.class);
    }

    /**
     * Gets known SecurityConfigurationRuleDirection values.
     *
     * @return known SecurityConfigurationRuleDirection values.
     */
    public static Collection<SecurityConfigurationRuleDirection> values() {
        return values(SecurityConfigurationRuleDirection.class);
    }
}
