/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.NetworkVirtualApplianceConnectionsClient;
import com.azure.resourcemanager.network.fluent.models.NetworkVirtualApplianceConnectionInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.NetworkVirtualApplianceConnectionList;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NetworkVirtualApplianceConnectionsClientImpl
implements NetworkVirtualApplianceConnectionsClient {
    private final NetworkVirtualApplianceConnectionsService service;
    private final NetworkManagementClientImpl client;

    NetworkVirtualApplianceConnectionsClientImpl(NetworkManagementClientImpl client) {
        this.service = (NetworkVirtualApplianceConnectionsService)RestProxy.create(NetworkVirtualApplianceConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName, NetworkVirtualApplianceConnectionInner networkVirtualApplianceConnectionParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkVirtualApplianceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        if (networkVirtualApplianceConnectionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceConnectionParameters is required and cannot be null."));
        }
        networkVirtualApplianceConnectionParameters.validate();
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkVirtualApplianceName, connectionName, "2023-04-01", networkVirtualApplianceConnectionParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName, NetworkVirtualApplianceConnectionInner networkVirtualApplianceConnectionParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkVirtualApplianceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        if (networkVirtualApplianceConnectionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceConnectionParameters is required and cannot be null."));
        }
        networkVirtualApplianceConnectionParameters.validate();
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkVirtualApplianceName, connectionName, "2023-04-01", networkVirtualApplianceConnectionParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<NetworkVirtualApplianceConnectionInner>, NetworkVirtualApplianceConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName, NetworkVirtualApplianceConnectionInner networkVirtualApplianceConnectionParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, networkVirtualApplianceName, connectionName, networkVirtualApplianceConnectionParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)NetworkVirtualApplianceConnectionInner.class), (Type)((Object)NetworkVirtualApplianceConnectionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NetworkVirtualApplianceConnectionInner>, NetworkVirtualApplianceConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName, NetworkVirtualApplianceConnectionInner networkVirtualApplianceConnectionParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, networkVirtualApplianceName, connectionName, networkVirtualApplianceConnectionParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)NetworkVirtualApplianceConnectionInner.class), (Type)((Object)NetworkVirtualApplianceConnectionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NetworkVirtualApplianceConnectionInner>, NetworkVirtualApplianceConnectionInner> beginCreateOrUpdate(String resourceGroupName, String networkVirtualApplianceName, String connectionName, NetworkVirtualApplianceConnectionInner networkVirtualApplianceConnectionParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, connectionName, networkVirtualApplianceConnectionParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NetworkVirtualApplianceConnectionInner>, NetworkVirtualApplianceConnectionInner> beginCreateOrUpdate(String resourceGroupName, String networkVirtualApplianceName, String connectionName, NetworkVirtualApplianceConnectionInner networkVirtualApplianceConnectionParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, connectionName, networkVirtualApplianceConnectionParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkVirtualApplianceConnectionInner> createOrUpdateAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName, NetworkVirtualApplianceConnectionInner networkVirtualApplianceConnectionParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, connectionName, networkVirtualApplianceConnectionParameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NetworkVirtualApplianceConnectionInner> createOrUpdateAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName, NetworkVirtualApplianceConnectionInner networkVirtualApplianceConnectionParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, connectionName, networkVirtualApplianceConnectionParameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkVirtualApplianceConnectionInner createOrUpdate(String resourceGroupName, String networkVirtualApplianceName, String connectionName, NetworkVirtualApplianceConnectionInner networkVirtualApplianceConnectionParameters) {
        return (NetworkVirtualApplianceConnectionInner)((Object)this.createOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, connectionName, networkVirtualApplianceConnectionParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkVirtualApplianceConnectionInner createOrUpdate(String resourceGroupName, String networkVirtualApplianceName, String connectionName, NetworkVirtualApplianceConnectionInner networkVirtualApplianceConnectionParameters, Context context) {
        return (NetworkVirtualApplianceConnectionInner)((Object)this.createOrUpdateAsync(resourceGroupName, networkVirtualApplianceName, connectionName, networkVirtualApplianceConnectionParameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NetworkVirtualApplianceConnectionInner>> getWithResponseAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkVirtualApplianceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkVirtualApplianceName, connectionName, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkVirtualApplianceConnectionInner>> getWithResponseAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkVirtualApplianceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkVirtualApplianceName, connectionName, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkVirtualApplianceConnectionInner> getAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName) {
        return this.getWithResponseAsync(resourceGroupName, networkVirtualApplianceName, connectionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NetworkVirtualApplianceConnectionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkVirtualApplianceConnectionInner> getWithResponse(String resourceGroupName, String networkVirtualApplianceName, String connectionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, networkVirtualApplianceName, connectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkVirtualApplianceConnectionInner get(String resourceGroupName, String networkVirtualApplianceName, String connectionName) {
        return (NetworkVirtualApplianceConnectionInner)((Object)this.getWithResponse(resourceGroupName, networkVirtualApplianceName, connectionName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkVirtualApplianceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkVirtualApplianceName, connectionName, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkVirtualApplianceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceName is required and cannot be null."));
        }
        if (connectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkVirtualApplianceName, connectionName, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkVirtualApplianceName, connectionName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkVirtualApplianceName, connectionName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkVirtualApplianceName, String connectionName) {
        return this.beginDeleteAsync(resourceGroupName, networkVirtualApplianceName, connectionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkVirtualApplianceName, String connectionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkVirtualApplianceName, connectionName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName) {
        return this.beginDeleteAsync(resourceGroupName, networkVirtualApplianceName, connectionName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String networkVirtualApplianceName, String connectionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkVirtualApplianceName, connectionName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkVirtualApplianceName, String connectionName) {
        this.deleteAsync(resourceGroupName, networkVirtualApplianceName, connectionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkVirtualApplianceName, String connectionName, Context context) {
        this.deleteAsync(resourceGroupName, networkVirtualApplianceName, connectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkVirtualApplianceConnectionInner>> listSinglePageAsync(String resourceGroupName, String networkVirtualApplianceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkVirtualApplianceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkVirtualApplianceName, "2023-04-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkVirtualApplianceConnectionList)res.getValue()).value(), ((NetworkVirtualApplianceConnectionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkVirtualApplianceConnectionInner>> listSinglePageAsync(String resourceGroupName, String networkVirtualApplianceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkVirtualApplianceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkVirtualApplianceName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkVirtualApplianceName, "2023-04-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkVirtualApplianceConnectionList)res.getValue()).value(), ((NetworkVirtualApplianceConnectionList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NetworkVirtualApplianceConnectionInner> listAsync(String resourceGroupName, String networkVirtualApplianceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkVirtualApplianceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NetworkVirtualApplianceConnectionInner> listAsync(String resourceGroupName, String networkVirtualApplianceName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkVirtualApplianceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkVirtualApplianceConnectionInner> list(String resourceGroupName, String networkVirtualApplianceName) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkVirtualApplianceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkVirtualApplianceConnectionInner> list(String resourceGroupName, String networkVirtualApplianceName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkVirtualApplianceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkVirtualApplianceConnectionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkVirtualApplianceConnectionList)res.getValue()).value(), ((NetworkVirtualApplianceConnectionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkVirtualApplianceConnectionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkVirtualApplianceConnectionList)res.getValue()).value(), ((NetworkVirtualApplianceConnectionList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface NetworkVirtualApplianceConnectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkVirtualAppliances/{networkVirtualApplianceName}/networkVirtualApplianceConnections/{connectionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkVirtualApplianceName") String var4, @PathParam(value="connectionName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") NetworkVirtualApplianceConnectionInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkVirtualAppliances/{networkVirtualApplianceName}/networkVirtualApplianceConnections/{connectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkVirtualApplianceConnectionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkVirtualApplianceName") String var4, @PathParam(value="connectionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkVirtualAppliances/{networkVirtualApplianceName}/networkVirtualApplianceConnections/{connectionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkVirtualApplianceName") String var4, @PathParam(value="connectionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkVirtualAppliances/{networkVirtualApplianceName}/networkVirtualApplianceConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkVirtualApplianceConnectionList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkVirtualApplianceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkVirtualApplianceConnectionList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

