// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Network Security Group resource. */
@Fluent
public final class NetworkSecurityGroupPropertiesFormat {
    /*
     * When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates.
     * Initial enablement will trigger re-evaluation.
     */
    @JsonProperty(value = "flushConnection")
    private Boolean flushConnection;

    /*
     * A collection of security rules of the network security group.
     */
    @JsonProperty(value = "securityRules")
    private List<SecurityRuleInner> securityRules;

    /*
     * The default security rules of network security group.
     */
    @JsonProperty(value = "defaultSecurityRules", access = JsonProperty.Access.WRITE_ONLY)
    private List<SecurityRuleInner> defaultSecurityRules;

    /*
     * A collection of references to network interfaces.
     */
    @JsonProperty(value = "networkInterfaces", access = JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceInner> networkInterfaces;

    /*
     * A collection of references to subnets.
     */
    @JsonProperty(value = "subnets", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubnetInner> subnets;

    /*
     * A collection of references to flow log resources.
     */
    @JsonProperty(value = "flowLogs", access = JsonProperty.Access.WRITE_ONLY)
    private List<FlowLogInner> flowLogs;

    /*
     * The resource GUID property of the network security group resource.
     */
    @JsonProperty(value = "resourceGuid", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;

    /*
     * The provisioning state of the network security group resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /** Creates an instance of NetworkSecurityGroupPropertiesFormat class. */
    public NetworkSecurityGroupPropertiesFormat() {
    }

    /**
     * Get the flushConnection property: When enabled, flows created from Network Security Group connections will be
     * re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
     *
     * @return the flushConnection value.
     */
    public Boolean flushConnection() {
        return this.flushConnection;
    }

    /**
     * Set the flushConnection property: When enabled, flows created from Network Security Group connections will be
     * re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
     *
     * @param flushConnection the flushConnection value to set.
     * @return the NetworkSecurityGroupPropertiesFormat object itself.
     */
    public NetworkSecurityGroupPropertiesFormat withFlushConnection(Boolean flushConnection) {
        this.flushConnection = flushConnection;
        return this;
    }

    /**
     * Get the securityRules property: A collection of security rules of the network security group.
     *
     * @return the securityRules value.
     */
    public List<SecurityRuleInner> securityRules() {
        return this.securityRules;
    }

    /**
     * Set the securityRules property: A collection of security rules of the network security group.
     *
     * @param securityRules the securityRules value to set.
     * @return the NetworkSecurityGroupPropertiesFormat object itself.
     */
    public NetworkSecurityGroupPropertiesFormat withSecurityRules(List<SecurityRuleInner> securityRules) {
        this.securityRules = securityRules;
        return this;
    }

    /**
     * Get the defaultSecurityRules property: The default security rules of network security group.
     *
     * @return the defaultSecurityRules value.
     */
    public List<SecurityRuleInner> defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    /**
     * Get the networkInterfaces property: A collection of references to network interfaces.
     *
     * @return the networkInterfaces value.
     */
    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.networkInterfaces;
    }

    /**
     * Get the subnets property: A collection of references to subnets.
     *
     * @return the subnets value.
     */
    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    /**
     * Get the flowLogs property: A collection of references to flow log resources.
     *
     * @return the flowLogs value.
     */
    public List<FlowLogInner> flowLogs() {
        return this.flowLogs;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the network security group resource.
     *
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the provisioningState property: The provisioning state of the network security group resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (securityRules() != null) {
            securityRules().forEach(e -> e.validate());
        }
        if (defaultSecurityRules() != null) {
            defaultSecurityRules().forEach(e -> e.validate());
        }
        if (networkInterfaces() != null) {
            networkInterfaces().forEach(e -> e.validate());
        }
        if (subnets() != null) {
            subnets().forEach(e -> e.validate());
        }
        if (flowLogs() != null) {
            flowLogs().forEach(e -> e.validate());
        }
    }
}
