// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule. */
public final class ApplicationGatewayFirewallRateLimitDuration
    extends ExpandableStringEnum<ApplicationGatewayFirewallRateLimitDuration> {
    /** Static value OneMin for ApplicationGatewayFirewallRateLimitDuration. */
    public static final ApplicationGatewayFirewallRateLimitDuration ONE_MIN = fromString("OneMin");

    /** Static value FiveMins for ApplicationGatewayFirewallRateLimitDuration. */
    public static final ApplicationGatewayFirewallRateLimitDuration FIVE_MINS = fromString("FiveMins");

    /**
     * Creates a new instance of ApplicationGatewayFirewallRateLimitDuration value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ApplicationGatewayFirewallRateLimitDuration() {
    }

    /**
     * Creates or finds a ApplicationGatewayFirewallRateLimitDuration from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ApplicationGatewayFirewallRateLimitDuration.
     */
    @JsonCreator
    public static ApplicationGatewayFirewallRateLimitDuration fromString(String name) {
        return fromString(name, ApplicationGatewayFirewallRateLimitDuration.class);
    }

    /**
     * Gets known ApplicationGatewayFirewallRateLimitDuration values.
     *
     * @return known ApplicationGatewayFirewallRateLimitDuration values.
     */
    public static Collection<ApplicationGatewayFirewallRateLimitDuration> values() {
        return values(ApplicationGatewayFirewallRateLimitDuration.class);
    }
}
