/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.NetworkManagerDeploymentStatusOperationsClient;
import com.azure.resourcemanager.network.fluent.models.NetworkManagerDeploymentStatusListResultInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.NetworkManagerDeploymentStatusParameter;
import reactor.core.publisher.Mono;

public final class NetworkManagerDeploymentStatusOperationsClientImpl
implements NetworkManagerDeploymentStatusOperationsClient {
    private final NetworkManagerDeploymentStatusOperationsService service;
    private final NetworkManagementClientImpl client;

    NetworkManagerDeploymentStatusOperationsClientImpl(NetworkManagementClientImpl client) {
        this.service = (NetworkManagerDeploymentStatusOperationsService)RestProxy.create(NetworkManagerDeploymentStatusOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NetworkManagerDeploymentStatusListResultInner>> listWithResponseAsync(String resourceGroupName, String networkManagerName, NetworkManagerDeploymentStatusParameter parameters, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, "2023-05-01", top, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkManagerDeploymentStatusListResultInner>> listWithResponseAsync(String resourceGroupName, String networkManagerName, NetworkManagerDeploymentStatusParameter parameters, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, "2023-05-01", top, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkManagerDeploymentStatusListResultInner> listAsync(String resourceGroupName, String networkManagerName, NetworkManagerDeploymentStatusParameter parameters) {
        Integer top = null;
        return this.listWithResponseAsync(resourceGroupName, networkManagerName, parameters, top).flatMap(res -> Mono.justOrEmpty((Object)((NetworkManagerDeploymentStatusListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkManagerDeploymentStatusListResultInner> listWithResponse(String resourceGroupName, String networkManagerName, NetworkManagerDeploymentStatusParameter parameters, Integer top, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, networkManagerName, parameters, top, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkManagerDeploymentStatusListResultInner list(String resourceGroupName, String networkManagerName, NetworkManagerDeploymentStatusParameter parameters) {
        Integer top = null;
        return (NetworkManagerDeploymentStatusListResultInner)this.listWithResponse(resourceGroupName, networkManagerName, parameters, top, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface NetworkManagerDeploymentStatusOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/listDeploymentStatus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkManagerDeploymentStatusListResultInner>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkManagerName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @BodyParam(value="application/json") NetworkManagerDeploymentStatusParameter var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

