/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayRedirectConfigurationInner;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayListener;
import com.azure.resourcemanager.network.models.ApplicationGatewayRedirectConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayRedirectType;
import com.azure.resourcemanager.network.models.ApplicationGatewayRequestRoutingRule;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

class ApplicationGatewayRedirectConfigurationImpl
extends ChildResourceImpl<ApplicationGatewayRedirectConfigurationInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayRedirectConfiguration,
ApplicationGatewayRedirectConfiguration.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayRedirectConfiguration.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayRedirectConfiguration.Update {
    ApplicationGatewayRedirectConfigurationImpl(ApplicationGatewayRedirectConfigurationInner inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).name();
    }

    @Override
    public ApplicationGatewayRedirectType type() {
        return ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).redirectType();
    }

    @Override
    public ApplicationGatewayListener targetListener() {
        SubResource ref = ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).targetListener();
        if (ref == null) {
            return null;
        }
        String name = ResourceUtils.nameFromResourceId((String)ref.id());
        return ((ApplicationGatewayImpl)this.parent()).listeners().get(name);
    }

    @Override
    public String targetUrl() {
        return ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).targetUrl();
    }

    @Override
    public Map<String, ApplicationGatewayRequestRoutingRule> requestRoutingRules() {
        TreeMap<String, ApplicationGatewayRequestRoutingRule> rules = new TreeMap<String, ApplicationGatewayRequestRoutingRule>();
        if (null != ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).requestRoutingRules()) {
            for (SubResource ruleRef : ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).requestRoutingRules()) {
                String ruleName = ResourceUtils.nameFromResourceId((String)ruleRef.id());
                ApplicationGatewayRequestRoutingRule rule = ((ApplicationGatewayImpl)this.parent()).requestRoutingRules().get(ruleName);
                if (null == rule) continue;
                rules.put(ruleName, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public boolean isPathIncluded() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).includePath());
    }

    @Override
    public boolean isQueryStringIncluded() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).includeQueryString());
    }

    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withRedirectConfiguration(this);
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl withTargetUrl(String url) {
        ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).withTargetUrl(url).withTargetListener(null).withIncludePath(null);
        return this;
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl withTargetListener(String name) {
        if (name == null) {
            ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).withTargetListener(null);
        } else {
            SubResource ref = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/httpListeners/" + name);
            ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).withTargetListener(ref).withTargetUrl(null);
        }
        return this;
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl withoutTargetListener() {
        ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).withTargetListener(null);
        return this;
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl withoutTargetUrl() {
        ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).withTargetUrl(null);
        return this;
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl withType(ApplicationGatewayRedirectType redirectType) {
        ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).withRedirectType(redirectType);
        return this;
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl withPathIncluded() {
        ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).withIncludePath(true);
        return this;
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl withQueryStringIncluded() {
        ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).withIncludeQueryString(true);
        return this;
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl withoutPathIncluded() {
        ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).withIncludePath(null);
        return this;
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl withoutQueryStringIncluded() {
        ((ApplicationGatewayRedirectConfigurationInner)((Object)this.innerModel())).withIncludeQueryString(null);
        return this;
    }
}

