/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityRuleAccess;
import com.azure.resourcemanager.network.models.SecurityRuleDirection;
import com.azure.resourcemanager.network.models.SecurityRuleProtocol;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class SecurityRulePropertiesFormat {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="protocol", required=true)
    private SecurityRuleProtocol protocol;
    @JsonProperty(value="sourcePortRange")
    private String sourcePortRange;
    @JsonProperty(value="destinationPortRange")
    private String destinationPortRange;
    @JsonProperty(value="sourceAddressPrefix")
    private String sourceAddressPrefix;
    @JsonProperty(value="sourceAddressPrefixes")
    private List<String> sourceAddressPrefixes;
    @JsonProperty(value="sourceApplicationSecurityGroups")
    private List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups;
    @JsonProperty(value="destinationAddressPrefix")
    private String destinationAddressPrefix;
    @JsonProperty(value="destinationAddressPrefixes")
    private List<String> destinationAddressPrefixes;
    @JsonProperty(value="destinationApplicationSecurityGroups")
    private List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups;
    @JsonProperty(value="sourcePortRanges")
    private List<String> sourcePortRanges;
    @JsonProperty(value="destinationPortRanges")
    private List<String> destinationPortRanges;
    @JsonProperty(value="access", required=true)
    private SecurityRuleAccess access;
    @JsonProperty(value="priority", required=true)
    private int priority;
    @JsonProperty(value="direction", required=true)
    private SecurityRuleDirection direction;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityRulePropertiesFormat.class);

    public String description() {
        return this.description;
    }

    public SecurityRulePropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    public SecurityRuleProtocol protocol() {
        return this.protocol;
    }

    public SecurityRulePropertiesFormat withProtocol(SecurityRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String sourcePortRange() {
        return this.sourcePortRange;
    }

    public SecurityRulePropertiesFormat withSourcePortRange(String sourcePortRange) {
        this.sourcePortRange = sourcePortRange;
        return this;
    }

    public String destinationPortRange() {
        return this.destinationPortRange;
    }

    public SecurityRulePropertiesFormat withDestinationPortRange(String destinationPortRange) {
        this.destinationPortRange = destinationPortRange;
        return this;
    }

    public String sourceAddressPrefix() {
        return this.sourceAddressPrefix;
    }

    public SecurityRulePropertiesFormat withSourceAddressPrefix(String sourceAddressPrefix) {
        this.sourceAddressPrefix = sourceAddressPrefix;
        return this;
    }

    public List<String> sourceAddressPrefixes() {
        return this.sourceAddressPrefixes;
    }

    public SecurityRulePropertiesFormat withSourceAddressPrefixes(List<String> sourceAddressPrefixes) {
        this.sourceAddressPrefixes = sourceAddressPrefixes;
        return this;
    }

    public List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups() {
        return this.sourceApplicationSecurityGroups;
    }

    public SecurityRulePropertiesFormat withSourceApplicationSecurityGroups(List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups) {
        this.sourceApplicationSecurityGroups = sourceApplicationSecurityGroups;
        return this;
    }

    public String destinationAddressPrefix() {
        return this.destinationAddressPrefix;
    }

    public SecurityRulePropertiesFormat withDestinationAddressPrefix(String destinationAddressPrefix) {
        this.destinationAddressPrefix = destinationAddressPrefix;
        return this;
    }

    public List<String> destinationAddressPrefixes() {
        return this.destinationAddressPrefixes;
    }

    public SecurityRulePropertiesFormat withDestinationAddressPrefixes(List<String> destinationAddressPrefixes) {
        this.destinationAddressPrefixes = destinationAddressPrefixes;
        return this;
    }

    public List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups() {
        return this.destinationApplicationSecurityGroups;
    }

    public SecurityRulePropertiesFormat withDestinationApplicationSecurityGroups(List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups) {
        this.destinationApplicationSecurityGroups = destinationApplicationSecurityGroups;
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public SecurityRulePropertiesFormat withSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public SecurityRulePropertiesFormat withDestinationPortRanges(List<String> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public SecurityRuleAccess access() {
        return this.access;
    }

    public SecurityRulePropertiesFormat withAccess(SecurityRuleAccess access) {
        this.access = access;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public SecurityRulePropertiesFormat withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public SecurityRuleDirection direction() {
        return this.direction;
    }

    public SecurityRulePropertiesFormat withDirection(SecurityRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property protocol in model SecurityRulePropertiesFormat"));
        }
        if (this.sourceApplicationSecurityGroups() != null) {
            this.sourceApplicationSecurityGroups().forEach(e -> e.validate());
        }
        if (this.destinationApplicationSecurityGroups() != null) {
            this.destinationApplicationSecurityGroups().forEach(e -> e.validate());
        }
        if (this.access() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property access in model SecurityRulePropertiesFormat"));
        }
        if (this.direction() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property direction in model SecurityRulePropertiesFormat"));
        }
    }
}

