// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Trusted Root certificates properties of an application gateway.
 */
@Fluent
public final class ApplicationGatewayTrustedRootCertificatePropertiesFormat {
    /*
     * Certificate public data.
     */
    @JsonProperty(value = "data")
    private String data;

    /*
     * Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
     */
    @JsonProperty(value = "keyVaultSecretId")
    private String keyVaultSecretId;

    /*
     * The provisioning state of the trusted root certificate resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayTrustedRootCertificatePropertiesFormat class.
     */
    public ApplicationGatewayTrustedRootCertificatePropertiesFormat() {
    }

    /**
     * Get the data property: Certificate public data.
     * 
     * @return the data value.
     */
    public String data() {
        return this.data;
    }

    /**
     * Set the data property: Certificate public data.
     * 
     * @param data the data value to set.
     * @return the ApplicationGatewayTrustedRootCertificatePropertiesFormat object itself.
     */
    public ApplicationGatewayTrustedRootCertificatePropertiesFormat withData(String data) {
        this.data = data;
        return this;
    }

    /**
     * Get the keyVaultSecretId property: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate'
     * object stored in KeyVault.
     * 
     * @return the keyVaultSecretId value.
     */
    public String keyVaultSecretId() {
        return this.keyVaultSecretId;
    }

    /**
     * Set the keyVaultSecretId property: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate'
     * object stored in KeyVault.
     * 
     * @param keyVaultSecretId the keyVaultSecretId value to set.
     * @return the ApplicationGatewayTrustedRootCertificatePropertiesFormat object itself.
     */
    public ApplicationGatewayTrustedRootCertificatePropertiesFormat withKeyVaultSecretId(String keyVaultSecretId) {
        this.keyVaultSecretId = keyVaultSecretId;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the trusted root certificate resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
