// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * ExpressRouteProviderPort resource.
 */
@Fluent
public final class ExpressRouteProviderPortInner extends Resource {
    /*
     * Properties of the express route Service Provider Port.
     */
    @JsonProperty(value = "properties")
    private ExpressRouteProviderPortProperties innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Creates an instance of ExpressRouteProviderPortInner class.
     */
    public ExpressRouteProviderPortInner() {
    }

    /**
     * Get the innerProperties property: Properties of the express route Service Provider Port.
     * 
     * @return the innerProperties value.
     */
    private ExpressRouteProviderPortProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the ExpressRouteProviderPortInner object itself.
     */
    public ExpressRouteProviderPortInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExpressRouteProviderPortInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExpressRouteProviderPortInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the portPairDescriptor property: The name of the port pair.
     * 
     * @return the portPairDescriptor value.
     */
    public String portPairDescriptor() {
        return this.innerProperties() == null ? null : this.innerProperties().portPairDescriptor();
    }

    /**
     * Get the primaryAzurePort property: The name of the primary port.
     * 
     * @return the primaryAzurePort value.
     */
    public String primaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryAzurePort();
    }

    /**
     * Get the secondaryAzurePort property: The name of the secondary port.
     * 
     * @return the secondaryAzurePort value.
     */
    public String secondaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryAzurePort();
    }

    /**
     * Get the peeringLocation property: The peering location of the port pair.
     * 
     * @return the peeringLocation value.
     */
    public String peeringLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().peeringLocation();
    }

    /**
     * Set the peeringLocation property: The peering location of the port pair.
     * 
     * @param peeringLocation the peeringLocation value to set.
     * @return the ExpressRouteProviderPortInner object itself.
     */
    public ExpressRouteProviderPortInner withPeeringLocation(String peeringLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteProviderPortProperties();
        }
        this.innerProperties().withPeeringLocation(peeringLocation);
        return this;
    }

    /**
     * Get the overprovisionFactor property: Overprovisioning factor for the port pair.
     * 
     * @return the overprovisionFactor value.
     */
    public Integer overprovisionFactor() {
        return this.innerProperties() == null ? null : this.innerProperties().overprovisionFactor();
    }

    /**
     * Set the overprovisionFactor property: Overprovisioning factor for the port pair.
     * 
     * @param overprovisionFactor the overprovisionFactor value to set.
     * @return the ExpressRouteProviderPortInner object itself.
     */
    public ExpressRouteProviderPortInner withOverprovisionFactor(Integer overprovisionFactor) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteProviderPortProperties();
        }
        this.innerProperties().withOverprovisionFactor(overprovisionFactor);
        return this;
    }

    /**
     * Get the portBandwidthInMbps property: Bandwidth of the port in Mbps.
     * 
     * @return the portBandwidthInMbps value.
     */
    public Integer portBandwidthInMbps() {
        return this.innerProperties() == null ? null : this.innerProperties().portBandwidthInMbps();
    }

    /**
     * Set the portBandwidthInMbps property: Bandwidth of the port in Mbps.
     * 
     * @param portBandwidthInMbps the portBandwidthInMbps value to set.
     * @return the ExpressRouteProviderPortInner object itself.
     */
    public ExpressRouteProviderPortInner withPortBandwidthInMbps(Integer portBandwidthInMbps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteProviderPortProperties();
        }
        this.innerProperties().withPortBandwidthInMbps(portBandwidthInMbps);
        return this;
    }

    /**
     * Get the usedBandwidthInMbps property: Used Bandwidth of the port in Mbps.
     * 
     * @return the usedBandwidthInMbps value.
     */
    public Integer usedBandwidthInMbps() {
        return this.innerProperties() == null ? null : this.innerProperties().usedBandwidthInMbps();
    }

    /**
     * Set the usedBandwidthInMbps property: Used Bandwidth of the port in Mbps.
     * 
     * @param usedBandwidthInMbps the usedBandwidthInMbps value to set.
     * @return the ExpressRouteProviderPortInner object itself.
     */
    public ExpressRouteProviderPortInner withUsedBandwidthInMbps(Integer usedBandwidthInMbps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteProviderPortProperties();
        }
        this.innerProperties().withUsedBandwidthInMbps(usedBandwidthInMbps);
        return this;
    }

    /**
     * Get the remainingBandwidthInMbps property: Remaining Bandwidth of the port in Mbps.
     * 
     * @return the remainingBandwidthInMbps value.
     */
    public Integer remainingBandwidthInMbps() {
        return this.innerProperties() == null ? null : this.innerProperties().remainingBandwidthInMbps();
    }

    /**
     * Set the remainingBandwidthInMbps property: Remaining Bandwidth of the port in Mbps.
     * 
     * @param remainingBandwidthInMbps the remainingBandwidthInMbps value to set.
     * @return the ExpressRouteProviderPortInner object itself.
     */
    public ExpressRouteProviderPortInner withRemainingBandwidthInMbps(Integer remainingBandwidthInMbps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteProviderPortProperties();
        }
        this.innerProperties().withRemainingBandwidthInMbps(remainingBandwidthInMbps);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
