// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.AzureFirewallThreatIntelMode;
import com.azure.resourcemanager.network.models.DnsSettings;
import com.azure.resourcemanager.network.models.ExplicitProxy;
import com.azure.resourcemanager.network.models.FirewallPolicyInsights;
import com.azure.resourcemanager.network.models.FirewallPolicyIntrusionDetection;
import com.azure.resourcemanager.network.models.FirewallPolicySnat;
import com.azure.resourcemanager.network.models.FirewallPolicySql;
import com.azure.resourcemanager.network.models.FirewallPolicyThreatIntelWhitelist;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The FirewallPolicyDraftProperties model.
 */
@Fluent
public final class FirewallPolicyDraftProperties {
    /*
     * The parent firewall policy from which rules are inherited.
     */
    @JsonProperty(value = "basePolicy")
    private SubResource basePolicy;

    /*
     * The operation mode for Threat Intelligence.
     */
    @JsonProperty(value = "threatIntelMode")
    private AzureFirewallThreatIntelMode threatIntelMode;

    /*
     * ThreatIntel Whitelist for Firewall Policy.
     */
    @JsonProperty(value = "threatIntelWhitelist")
    private FirewallPolicyThreatIntelWhitelist threatIntelWhitelist;

    /*
     * Insights on Firewall Policy.
     */
    @JsonProperty(value = "insights")
    private FirewallPolicyInsights insights;

    /*
     * The private IP addresses/IP ranges to which traffic will not be SNAT.
     */
    @JsonProperty(value = "snat")
    private FirewallPolicySnat snat;

    /*
     * SQL Settings definition.
     */
    @JsonProperty(value = "sql")
    private FirewallPolicySql sql;

    /*
     * DNS Proxy Settings definition.
     */
    @JsonProperty(value = "dnsSettings")
    private DnsSettings dnsSettings;

    /*
     * Explicit Proxy Settings definition.
     */
    @JsonProperty(value = "explicitProxy")
    private ExplicitProxy explicitProxy;

    /*
     * The configuration for Intrusion detection.
     */
    @JsonProperty(value = "intrusionDetection")
    private FirewallPolicyIntrusionDetection intrusionDetection;

    /**
     * Creates an instance of FirewallPolicyDraftProperties class.
     */
    public FirewallPolicyDraftProperties() {
    }

    /**
     * Get the basePolicy property: The parent firewall policy from which rules are inherited.
     * 
     * @return the basePolicy value.
     */
    public SubResource basePolicy() {
        return this.basePolicy;
    }

    /**
     * Set the basePolicy property: The parent firewall policy from which rules are inherited.
     * 
     * @param basePolicy the basePolicy value to set.
     * @return the FirewallPolicyDraftProperties object itself.
     */
    public FirewallPolicyDraftProperties withBasePolicy(SubResource basePolicy) {
        this.basePolicy = basePolicy;
        return this;
    }

    /**
     * Get the threatIntelMode property: The operation mode for Threat Intelligence.
     * 
     * @return the threatIntelMode value.
     */
    public AzureFirewallThreatIntelMode threatIntelMode() {
        return this.threatIntelMode;
    }

    /**
     * Set the threatIntelMode property: The operation mode for Threat Intelligence.
     * 
     * @param threatIntelMode the threatIntelMode value to set.
     * @return the FirewallPolicyDraftProperties object itself.
     */
    public FirewallPolicyDraftProperties withThreatIntelMode(AzureFirewallThreatIntelMode threatIntelMode) {
        this.threatIntelMode = threatIntelMode;
        return this;
    }

    /**
     * Get the threatIntelWhitelist property: ThreatIntel Whitelist for Firewall Policy.
     * 
     * @return the threatIntelWhitelist value.
     */
    public FirewallPolicyThreatIntelWhitelist threatIntelWhitelist() {
        return this.threatIntelWhitelist;
    }

    /**
     * Set the threatIntelWhitelist property: ThreatIntel Whitelist for Firewall Policy.
     * 
     * @param threatIntelWhitelist the threatIntelWhitelist value to set.
     * @return the FirewallPolicyDraftProperties object itself.
     */
    public FirewallPolicyDraftProperties
        withThreatIntelWhitelist(FirewallPolicyThreatIntelWhitelist threatIntelWhitelist) {
        this.threatIntelWhitelist = threatIntelWhitelist;
        return this;
    }

    /**
     * Get the insights property: Insights on Firewall Policy.
     * 
     * @return the insights value.
     */
    public FirewallPolicyInsights insights() {
        return this.insights;
    }

    /**
     * Set the insights property: Insights on Firewall Policy.
     * 
     * @param insights the insights value to set.
     * @return the FirewallPolicyDraftProperties object itself.
     */
    public FirewallPolicyDraftProperties withInsights(FirewallPolicyInsights insights) {
        this.insights = insights;
        return this;
    }

    /**
     * Get the snat property: The private IP addresses/IP ranges to which traffic will not be SNAT.
     * 
     * @return the snat value.
     */
    public FirewallPolicySnat snat() {
        return this.snat;
    }

    /**
     * Set the snat property: The private IP addresses/IP ranges to which traffic will not be SNAT.
     * 
     * @param snat the snat value to set.
     * @return the FirewallPolicyDraftProperties object itself.
     */
    public FirewallPolicyDraftProperties withSnat(FirewallPolicySnat snat) {
        this.snat = snat;
        return this;
    }

    /**
     * Get the sql property: SQL Settings definition.
     * 
     * @return the sql value.
     */
    public FirewallPolicySql sql() {
        return this.sql;
    }

    /**
     * Set the sql property: SQL Settings definition.
     * 
     * @param sql the sql value to set.
     * @return the FirewallPolicyDraftProperties object itself.
     */
    public FirewallPolicyDraftProperties withSql(FirewallPolicySql sql) {
        this.sql = sql;
        return this;
    }

    /**
     * Get the dnsSettings property: DNS Proxy Settings definition.
     * 
     * @return the dnsSettings value.
     */
    public DnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    /**
     * Set the dnsSettings property: DNS Proxy Settings definition.
     * 
     * @param dnsSettings the dnsSettings value to set.
     * @return the FirewallPolicyDraftProperties object itself.
     */
    public FirewallPolicyDraftProperties withDnsSettings(DnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    /**
     * Get the explicitProxy property: Explicit Proxy Settings definition.
     * 
     * @return the explicitProxy value.
     */
    public ExplicitProxy explicitProxy() {
        return this.explicitProxy;
    }

    /**
     * Set the explicitProxy property: Explicit Proxy Settings definition.
     * 
     * @param explicitProxy the explicitProxy value to set.
     * @return the FirewallPolicyDraftProperties object itself.
     */
    public FirewallPolicyDraftProperties withExplicitProxy(ExplicitProxy explicitProxy) {
        this.explicitProxy = explicitProxy;
        return this;
    }

    /**
     * Get the intrusionDetection property: The configuration for Intrusion detection.
     * 
     * @return the intrusionDetection value.
     */
    public FirewallPolicyIntrusionDetection intrusionDetection() {
        return this.intrusionDetection;
    }

    /**
     * Set the intrusionDetection property: The configuration for Intrusion detection.
     * 
     * @param intrusionDetection the intrusionDetection value to set.
     * @return the FirewallPolicyDraftProperties object itself.
     */
    public FirewallPolicyDraftProperties withIntrusionDetection(FirewallPolicyIntrusionDetection intrusionDetection) {
        this.intrusionDetection = intrusionDetection;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (threatIntelWhitelist() != null) {
            threatIntelWhitelist().validate();
        }
        if (insights() != null) {
            insights().validate();
        }
        if (snat() != null) {
            snat().validate();
        }
        if (sql() != null) {
            sql().validate();
        }
        if (dnsSettings() != null) {
            dnsSettings().validate();
        }
        if (explicitProxy() != null) {
            explicitProxy().validate();
        }
        if (intrusionDetection() != null) {
            intrusionDetection().validate();
        }
    }
}
