// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The IpGroups property information.
 */
@Fluent
public final class IpGroupPropertiesFormat {
    /*
     * The provisioning state of the IpGroups resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * IpAddresses/IpAddressPrefixes in the IpGroups resource.
     */
    @JsonProperty(value = "ipAddresses")
    private List<String> ipAddresses;

    /*
     * List of references to Firewall resources that this IpGroups is associated with.
     */
    @JsonProperty(value = "firewalls", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> firewalls;

    /*
     * List of references to Firewall Policies resources that this IpGroups is associated with.
     */
    @JsonProperty(value = "firewallPolicies", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> firewallPolicies;

    /**
     * Creates an instance of IpGroupPropertiesFormat class.
     */
    public IpGroupPropertiesFormat() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the IpGroups resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the ipAddresses property: IpAddresses/IpAddressPrefixes in the IpGroups resource.
     * 
     * @return the ipAddresses value.
     */
    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    /**
     * Set the ipAddresses property: IpAddresses/IpAddressPrefixes in the IpGroups resource.
     * 
     * @param ipAddresses the ipAddresses value to set.
     * @return the IpGroupPropertiesFormat object itself.
     */
    public IpGroupPropertiesFormat withIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    /**
     * Get the firewalls property: List of references to Firewall resources that this IpGroups is associated with.
     * 
     * @return the firewalls value.
     */
    public List<SubResource> firewalls() {
        return this.firewalls;
    }

    /**
     * Get the firewallPolicies property: List of references to Firewall Policies resources that this IpGroups is
     * associated with.
     * 
     * @return the firewallPolicies value.
     */
    public List<SubResource> firewallPolicies() {
        return this.firewallPolicies;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
