// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.NetworkManagerDeploymentStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A list of Network Manager Deployment Status.
 */
@Fluent
public final class NetworkManagerDeploymentStatusListResultInner {
    /*
     * Gets a page of Network Manager Deployment Status
     */
    @JsonProperty(value = "value")
    private List<NetworkManagerDeploymentStatus> value;

    /*
     * When present, the value can be passed to a subsequent query call (together with the same query and scopes used in
     * the current request) to retrieve the next page of data.
     */
    @JsonProperty(value = "skipToken")
    private String skipToken;

    /**
     * Creates an instance of NetworkManagerDeploymentStatusListResultInner class.
     */
    public NetworkManagerDeploymentStatusListResultInner() {
    }

    /**
     * Get the value property: Gets a page of Network Manager Deployment Status.
     * 
     * @return the value value.
     */
    public List<NetworkManagerDeploymentStatus> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of Network Manager Deployment Status.
     * 
     * @param value the value value to set.
     * @return the NetworkManagerDeploymentStatusListResultInner object itself.
     */
    public NetworkManagerDeploymentStatusListResultInner withValue(List<NetworkManagerDeploymentStatus> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the skipToken property: When present, the value can be passed to a subsequent query call (together with the
     * same query and scopes used in the current request) to retrieve the next page of data.
     * 
     * @return the skipToken value.
     */
    public String skipToken() {
        return this.skipToken;
    }

    /**
     * Set the skipToken property: When present, the value can be passed to a subsequent query call (together with the
     * same query and scopes used in the current request) to retrieve the next page of data.
     * 
     * @param skipToken the skipToken value to set.
     * @return the NetworkManagerDeploymentStatusListResultInner object itself.
     */
    public NetworkManagerDeploymentStatusListResultInner withSkipToken(String skipToken) {
        this.skipToken = skipToken;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
