// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.BastionSessionStateInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Response for DisconnectActiveSessions.
 */
@Fluent
public final class BastionSessionDeleteResult {
    /*
     * List of sessions with their corresponding state.
     */
    @JsonProperty(value = "value")
    private List<BastionSessionStateInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of BastionSessionDeleteResult class.
     */
    public BastionSessionDeleteResult() {
    }

    /**
     * Get the value property: List of sessions with their corresponding state.
     * 
     * @return the value value.
     */
    public List<BastionSessionStateInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of sessions with their corresponding state.
     * 
     * @param value the value value to set.
     * @return the BastionSessionDeleteResult object itself.
     */
    public BastionSessionDeleteResult withValue(List<BastionSessionStateInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the BastionSessionDeleteResult object itself.
     */
    public BastionSessionDeleteResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
