// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.P2SVpnGatewayInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Result of the request to list P2SVpnGateways. It contains a list of P2SVpnGateways and a URL nextLink to get the next
 * set of results.
 */
@Fluent
public final class ListP2SVpnGatewaysResult {
    /*
     * List of P2SVpnGateways.
     */
    @JsonProperty(value = "value")
    private List<P2SVpnGatewayInner> value;

    /*
     * URL to get the next set of operation list results if there are any.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of ListP2SVpnGatewaysResult class.
     */
    public ListP2SVpnGatewaysResult() {
    }

    /**
     * Get the value property: List of P2SVpnGateways.
     * 
     * @return the value value.
     */
    public List<P2SVpnGatewayInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of P2SVpnGateways.
     * 
     * @param value the value value to set.
     * @return the ListP2SVpnGatewaysResult object itself.
     */
    public ListP2SVpnGatewaysResult withValue(List<P2SVpnGatewayInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ListP2SVpnGatewaysResult object itself.
     */
    public ListP2SVpnGatewaysResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
