// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Network Profile containing configurations for Public and Private NIC.
 */
@Fluent
public final class NetworkVirtualAppliancePropertiesFormatNetworkProfile {
    /*
     * The networkInterfaceConfigurations property.
     */
    @JsonProperty(value = "networkInterfaceConfigurations")
    private List<VirtualApplianceNetworkInterfaceConfiguration> networkInterfaceConfigurations;

    /**
     * Creates an instance of NetworkVirtualAppliancePropertiesFormatNetworkProfile class.
     */
    public NetworkVirtualAppliancePropertiesFormatNetworkProfile() {
    }

    /**
     * Get the networkInterfaceConfigurations property: The networkInterfaceConfigurations property.
     * 
     * @return the networkInterfaceConfigurations value.
     */
    public List<VirtualApplianceNetworkInterfaceConfiguration> networkInterfaceConfigurations() {
        return this.networkInterfaceConfigurations;
    }

    /**
     * Set the networkInterfaceConfigurations property: The networkInterfaceConfigurations property.
     * 
     * @param networkInterfaceConfigurations the networkInterfaceConfigurations value to set.
     * @return the NetworkVirtualAppliancePropertiesFormatNetworkProfile object itself.
     */
    public NetworkVirtualAppliancePropertiesFormatNetworkProfile withNetworkInterfaceConfigurations(
        List<VirtualApplianceNetworkInterfaceConfiguration> networkInterfaceConfigurations) {
        this.networkInterfaceConfigurations = networkInterfaceConfigurations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkInterfaceConfigurations() != null) {
            networkInterfaceConfigurations().forEach(e -> e.validate());
        }
    }
}
