// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * NIC type - PublicNic, PrivateNic, or AdditionalNic.
 */
public final class NicTypeInResponse extends ExpandableStringEnum<NicTypeInResponse> {
    /**
     * Static value PublicNic for NicTypeInResponse.
     */
    public static final NicTypeInResponse PUBLIC_NIC = fromString("PublicNic");

    /**
     * Static value PrivateNic for NicTypeInResponse.
     */
    public static final NicTypeInResponse PRIVATE_NIC = fromString("PrivateNic");

    /**
     * Static value AdditionalNic for NicTypeInResponse.
     */
    public static final NicTypeInResponse ADDITIONAL_NIC = fromString("AdditionalNic");

    /**
     * Creates a new instance of NicTypeInResponse value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NicTypeInResponse() {
    }

    /**
     * Creates or finds a NicTypeInResponse from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NicTypeInResponse.
     */
    @JsonCreator
    public static NicTypeInResponse fromString(String name) {
        return fromString(name, NicTypeInResponse.class);
    }

    /**
     * Gets known NicTypeInResponse values.
     * 
     * @return known NicTypeInResponse values.
     */
    public static Collection<NicTypeInResponse> values() {
        return values(NicTypeInResponse.class);
    }
}
