// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Determines how new connections are handled by the load balancer when all backend instances are probed down.
 */
public final class ProbeNoHealthyBackendsBehavior extends ExpandableStringEnum<ProbeNoHealthyBackendsBehavior> {
    /**
     * Static value AllProbedDown for ProbeNoHealthyBackendsBehavior.
     */
    public static final ProbeNoHealthyBackendsBehavior ALL_PROBED_DOWN = fromString("AllProbedDown");

    /**
     * Static value AllProbedUp for ProbeNoHealthyBackendsBehavior.
     */
    public static final ProbeNoHealthyBackendsBehavior ALL_PROBED_UP = fromString("AllProbedUp");

    /**
     * Creates a new instance of ProbeNoHealthyBackendsBehavior value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ProbeNoHealthyBackendsBehavior() {
    }

    /**
     * Creates or finds a ProbeNoHealthyBackendsBehavior from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ProbeNoHealthyBackendsBehavior.
     */
    @JsonCreator
    public static ProbeNoHealthyBackendsBehavior fromString(String name) {
        return fromString(name, ProbeNoHealthyBackendsBehavior.class);
    }

    /**
     * Gets known ProbeNoHealthyBackendsBehavior values.
     * 
     * @return known ProbeNoHealthyBackendsBehavior values.
     */
    public static Collection<ProbeNoHealthyBackendsBehavior> values() {
        return values(ProbeNoHealthyBackendsBehavior.class);
    }
}
