// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents a single IP configuration.
 */
@Fluent
public final class VirtualApplianceIpConfiguration {
    /*
     * Name of the IP configuration.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Represents a single IP configuration properties.
     */
    @JsonProperty(value = "properties")
    private VirtualApplianceIpConfigurationProperties properties;

    /**
     * Creates an instance of VirtualApplianceIpConfiguration class.
     */
    public VirtualApplianceIpConfiguration() {
    }

    /**
     * Get the name property: Name of the IP configuration.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the IP configuration.
     * 
     * @param name the name value to set.
     * @return the VirtualApplianceIpConfiguration object itself.
     */
    public VirtualApplianceIpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the properties property: Represents a single IP configuration properties.
     * 
     * @return the properties value.
     */
    public VirtualApplianceIpConfigurationProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Represents a single IP configuration properties.
     * 
     * @param properties the properties value to set.
     * @return the VirtualApplianceIpConfiguration object itself.
     */
    public VirtualApplianceIpConfiguration withProperties(VirtualApplianceIpConfigurationProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
