// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents a single IP configuration properties.
 */
@Fluent
public final class VirtualApplianceIpConfigurationProperties {
    /*
     * Whether or not this is primary IP configuration of the NIC.
     */
    @JsonProperty(value = "primary")
    private Boolean primary;

    /**
     * Creates an instance of VirtualApplianceIpConfigurationProperties class.
     */
    public VirtualApplianceIpConfigurationProperties() {
    }

    /**
     * Get the primary property: Whether or not this is primary IP configuration of the NIC.
     * 
     * @return the primary value.
     */
    public Boolean primary() {
        return this.primary;
    }

    /**
     * Set the primary property: Whether or not this is primary IP configuration of the NIC.
     * 
     * @param primary the primary value to set.
     * @return the VirtualApplianceIpConfigurationProperties object itself.
     */
    public VirtualApplianceIpConfigurationProperties withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
