// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents a single NIC configuration.
 */
@Fluent
public final class VirtualApplianceNetworkInterfaceConfiguration {
    /*
     * NIC type. This should be either PublicNic or PrivateNic.
     */
    @JsonProperty(value = "type")
    private NicTypeInRequest nicType;

    /*
     * Represents a single NIC configuration properties.
     */
    @JsonProperty(value = "properties")
    private VirtualApplianceNetworkInterfaceConfigurationProperties properties;

    /**
     * Creates an instance of VirtualApplianceNetworkInterfaceConfiguration class.
     */
    public VirtualApplianceNetworkInterfaceConfiguration() {
    }

    /**
     * Get the nicType property: NIC type. This should be either PublicNic or PrivateNic.
     * 
     * @return the nicType value.
     */
    public NicTypeInRequest nicType() {
        return this.nicType;
    }

    /**
     * Set the nicType property: NIC type. This should be either PublicNic or PrivateNic.
     * 
     * @param nicType the nicType value to set.
     * @return the VirtualApplianceNetworkInterfaceConfiguration object itself.
     */
    public VirtualApplianceNetworkInterfaceConfiguration withNicType(NicTypeInRequest nicType) {
        this.nicType = nicType;
        return this;
    }

    /**
     * Get the properties property: Represents a single NIC configuration properties.
     * 
     * @return the properties value.
     */
    public VirtualApplianceNetworkInterfaceConfigurationProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Represents a single NIC configuration properties.
     * 
     * @param properties the properties value to set.
     * @return the VirtualApplianceNetworkInterfaceConfiguration object itself.
     */
    public VirtualApplianceNetworkInterfaceConfiguration
        withProperties(VirtualApplianceNetworkInterfaceConfigurationProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
