// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The VirtualNetworkGatewayAutoScaleBounds model.
 */
@Fluent
public final class VirtualNetworkGatewayAutoScaleBounds {
    /*
     * Minimum scale Units for Autoscale configuration
     */
    @JsonProperty(value = "min")
    private Integer min;

    /*
     * Maximum Scale Units for Autoscale configuration
     */
    @JsonProperty(value = "max")
    private Integer max;

    /**
     * Creates an instance of VirtualNetworkGatewayAutoScaleBounds class.
     */
    public VirtualNetworkGatewayAutoScaleBounds() {
    }

    /**
     * Get the min property: Minimum scale Units for Autoscale configuration.
     * 
     * @return the min value.
     */
    public Integer min() {
        return this.min;
    }

    /**
     * Set the min property: Minimum scale Units for Autoscale configuration.
     * 
     * @param min the min value to set.
     * @return the VirtualNetworkGatewayAutoScaleBounds object itself.
     */
    public VirtualNetworkGatewayAutoScaleBounds withMin(Integer min) {
        this.min = min;
        return this;
    }

    /**
     * Get the max property: Maximum Scale Units for Autoscale configuration.
     * 
     * @return the max value.
     */
    public Integer max() {
        return this.max;
    }

    /**
     * Set the max property: Maximum Scale Units for Autoscale configuration.
     * 
     * @param max the max value to set.
     * @return the VirtualNetworkGatewayAutoScaleBounds object itself.
     */
    public VirtualNetworkGatewayAutoScaleBounds withMax(Integer max) {
        this.max = max;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
