// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Virtual Network Gateway Autoscale Configuration details.
 */
@Fluent
public final class VirtualNetworkGatewayAutoScaleConfiguration {
    /*
     * The bounds of the autoscale configuration
     */
    @JsonProperty(value = "bounds")
    private VirtualNetworkGatewayAutoScaleBounds bounds;

    /**
     * Creates an instance of VirtualNetworkGatewayAutoScaleConfiguration class.
     */
    public VirtualNetworkGatewayAutoScaleConfiguration() {
    }

    /**
     * Get the bounds property: The bounds of the autoscale configuration.
     * 
     * @return the bounds value.
     */
    public VirtualNetworkGatewayAutoScaleBounds bounds() {
        return this.bounds;
    }

    /**
     * Set the bounds property: The bounds of the autoscale configuration.
     * 
     * @param bounds the bounds value to set.
     * @return the VirtualNetworkGatewayAutoScaleConfiguration object itself.
     */
    public VirtualNetworkGatewayAutoScaleConfiguration withBounds(VirtualNetworkGatewayAutoScaleBounds bounds) {
        this.bounds = bounds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (bounds() != null) {
            bounds().validate();
        }
    }
}
