// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * List of routes that control routing from VirtualHub into a virtual network connection.
 */
@Fluent
public final class VnetRoute {
    /*
     * Configuration for static routes on this HubVnetConnection.
     */
    @JsonProperty(value = "staticRoutesConfig")
    private StaticRoutesConfig staticRoutesConfig;

    /*
     * List of all Static Routes.
     */
    @JsonProperty(value = "staticRoutes")
    private List<StaticRoute> staticRoutes;

    /*
     * The list of references to HubBgpConnection objects.
     */
    @JsonProperty(value = "bgpConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> bgpConnections;

    /**
     * Creates an instance of VnetRoute class.
     */
    public VnetRoute() {
    }

    /**
     * Get the staticRoutesConfig property: Configuration for static routes on this HubVnetConnection.
     * 
     * @return the staticRoutesConfig value.
     */
    public StaticRoutesConfig staticRoutesConfig() {
        return this.staticRoutesConfig;
    }

    /**
     * Set the staticRoutesConfig property: Configuration for static routes on this HubVnetConnection.
     * 
     * @param staticRoutesConfig the staticRoutesConfig value to set.
     * @return the VnetRoute object itself.
     */
    public VnetRoute withStaticRoutesConfig(StaticRoutesConfig staticRoutesConfig) {
        this.staticRoutesConfig = staticRoutesConfig;
        return this;
    }

    /**
     * Get the staticRoutes property: List of all Static Routes.
     * 
     * @return the staticRoutes value.
     */
    public List<StaticRoute> staticRoutes() {
        return this.staticRoutes;
    }

    /**
     * Set the staticRoutes property: List of all Static Routes.
     * 
     * @param staticRoutes the staticRoutes value to set.
     * @return the VnetRoute object itself.
     */
    public VnetRoute withStaticRoutes(List<StaticRoute> staticRoutes) {
        this.staticRoutes = staticRoutes;
        return this;
    }

    /**
     * Get the bgpConnections property: The list of references to HubBgpConnection objects.
     * 
     * @return the bgpConnections value.
     */
    public List<SubResource> bgpConnections() {
        return this.bgpConnections;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (staticRoutesConfig() != null) {
            staticRoutesConfig().validate();
        }
        if (staticRoutes() != null) {
            staticRoutes().forEach(e -> e.validate());
        }
    }
}
