/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AddressPrefixItem;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleAccess;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleDirection;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleProtocol;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AdminPropertiesFormat {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="protocol", required=true)
    private SecurityConfigurationRuleProtocol protocol;
    @JsonProperty(value="sources")
    private List<AddressPrefixItem> sources;
    @JsonProperty(value="destinations")
    private List<AddressPrefixItem> destinations;
    @JsonProperty(value="sourcePortRanges")
    private List<String> sourcePortRanges;
    @JsonProperty(value="destinationPortRanges")
    private List<String> destinationPortRanges;
    @JsonProperty(value="access", required=true)
    private SecurityConfigurationRuleAccess access;
    @JsonProperty(value="priority", required=true)
    private int priority;
    @JsonProperty(value="direction", required=true)
    private SecurityConfigurationRuleDirection direction;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(AdminPropertiesFormat.class);

    public String description() {
        return this.description;
    }

    public AdminPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    public SecurityConfigurationRuleProtocol protocol() {
        return this.protocol;
    }

    public AdminPropertiesFormat withProtocol(SecurityConfigurationRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public List<AddressPrefixItem> sources() {
        return this.sources;
    }

    public AdminPropertiesFormat withSources(List<AddressPrefixItem> sources) {
        this.sources = sources;
        return this;
    }

    public List<AddressPrefixItem> destinations() {
        return this.destinations;
    }

    public AdminPropertiesFormat withDestinations(List<AddressPrefixItem> destinations) {
        this.destinations = destinations;
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public AdminPropertiesFormat withSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public AdminPropertiesFormat withDestinationPortRanges(List<String> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public SecurityConfigurationRuleAccess access() {
        return this.access;
    }

    public AdminPropertiesFormat withAccess(SecurityConfigurationRuleAccess access) {
        this.access = access;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public AdminPropertiesFormat withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public SecurityConfigurationRuleDirection direction() {
        return this.direction;
    }

    public AdminPropertiesFormat withDirection(SecurityConfigurationRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model AdminPropertiesFormat"));
        }
        if (this.sources() != null) {
            this.sources().forEach(e -> e.validate());
        }
        if (this.destinations() != null) {
            this.destinations().forEach(e -> e.validate());
        }
        if (this.access() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property access in model AdminPropertiesFormat"));
        }
        if (this.direction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property direction in model AdminPropertiesFormat"));
        }
    }
}

