/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class BastionHostIpConfigurationPropertiesFormat {
    @JsonProperty(value="subnet", required=true)
    private SubResource subnet;
    @JsonProperty(value="publicIPAddress", required=true)
    private SubResource publicIpAddress;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="privateIPAllocationMethod")
    private IpAllocationMethod privateIpAllocationMethod;
    private static final ClientLogger LOGGER = new ClientLogger(BastionHostIpConfigurationPropertiesFormat.class);

    public SubResource subnet() {
        return this.subnet;
    }

    public BastionHostIpConfigurationPropertiesFormat withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    public SubResource publicIpAddress() {
        return this.publicIpAddress;
    }

    public BastionHostIpConfigurationPropertiesFormat withPublicIpAddress(SubResource publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public BastionHostIpConfigurationPropertiesFormat withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public void validate() {
        if (this.subnet() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnet in model BastionHostIpConfigurationPropertiesFormat"));
        }
        if (this.publicIpAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publicIpAddress in model BastionHostIpConfigurationPropertiesFormat"));
        }
    }
}

