/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.LoadDistribution;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TransportProtocol;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class LoadBalancingRulePropertiesFormat {
    @JsonProperty(value="frontendIPConfiguration")
    private SubResource frontendIpConfiguration;
    @JsonProperty(value="backendAddressPool")
    private SubResource backendAddressPool;
    @JsonProperty(value="backendAddressPools")
    private List<SubResource> backendAddressPools;
    @JsonProperty(value="probe")
    private SubResource probe;
    @JsonProperty(value="protocol", required=true)
    private TransportProtocol protocol;
    @JsonProperty(value="loadDistribution")
    private LoadDistribution loadDistribution;
    @JsonProperty(value="frontendPort", required=true)
    private int frontendPort;
    @JsonProperty(value="backendPort")
    private Integer backendPort;
    @JsonProperty(value="idleTimeoutInMinutes")
    private Integer idleTimeoutInMinutes;
    @JsonProperty(value="enableFloatingIP")
    private Boolean enableFloatingIp;
    @JsonProperty(value="enableTcpReset")
    private Boolean enableTcpReset;
    @JsonProperty(value="disableOutboundSnat")
    private Boolean disableOutboundSnat;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(LoadBalancingRulePropertiesFormat.class);

    public SubResource frontendIpConfiguration() {
        return this.frontendIpConfiguration;
    }

    public LoadBalancingRulePropertiesFormat withFrontendIpConfiguration(SubResource frontendIpConfiguration) {
        this.frontendIpConfiguration = frontendIpConfiguration;
        return this;
    }

    public SubResource backendAddressPool() {
        return this.backendAddressPool;
    }

    public LoadBalancingRulePropertiesFormat withBackendAddressPool(SubResource backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    public List<SubResource> backendAddressPools() {
        return this.backendAddressPools;
    }

    public LoadBalancingRulePropertiesFormat withBackendAddressPools(List<SubResource> backendAddressPools) {
        this.backendAddressPools = backendAddressPools;
        return this;
    }

    public SubResource probe() {
        return this.probe;
    }

    public LoadBalancingRulePropertiesFormat withProbe(SubResource probe) {
        this.probe = probe;
        return this;
    }

    public TransportProtocol protocol() {
        return this.protocol;
    }

    public LoadBalancingRulePropertiesFormat withProtocol(TransportProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public LoadDistribution loadDistribution() {
        return this.loadDistribution;
    }

    public LoadBalancingRulePropertiesFormat withLoadDistribution(LoadDistribution loadDistribution) {
        this.loadDistribution = loadDistribution;
        return this;
    }

    public int frontendPort() {
        return this.frontendPort;
    }

    public LoadBalancingRulePropertiesFormat withFrontendPort(int frontendPort) {
        this.frontendPort = frontendPort;
        return this;
    }

    public Integer backendPort() {
        return this.backendPort;
    }

    public LoadBalancingRulePropertiesFormat withBackendPort(Integer backendPort) {
        this.backendPort = backendPort;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public LoadBalancingRulePropertiesFormat withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public Boolean enableFloatingIp() {
        return this.enableFloatingIp;
    }

    public LoadBalancingRulePropertiesFormat withEnableFloatingIp(Boolean enableFloatingIp) {
        this.enableFloatingIp = enableFloatingIp;
        return this;
    }

    public Boolean enableTcpReset() {
        return this.enableTcpReset;
    }

    public LoadBalancingRulePropertiesFormat withEnableTcpReset(Boolean enableTcpReset) {
        this.enableTcpReset = enableTcpReset;
        return this;
    }

    public Boolean disableOutboundSnat() {
        return this.disableOutboundSnat;
    }

    public LoadBalancingRulePropertiesFormat withDisableOutboundSnat(Boolean disableOutboundSnat) {
        this.disableOutboundSnat = disableOutboundSnat;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model LoadBalancingRulePropertiesFormat"));
        }
    }
}

