/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProbeNoHealthyBackendsBehavior;
import com.azure.resourcemanager.network.models.ProbeProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ProbePropertiesFormat {
    @JsonProperty(value="loadBalancingRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> loadBalancingRules;
    @JsonProperty(value="protocol", required=true)
    private ProbeProtocol protocol;
    @JsonProperty(value="port", required=true)
    private int port;
    @JsonProperty(value="intervalInSeconds")
    private Integer intervalInSeconds;
    @JsonProperty(value="NoHealthyBackendsBehavior")
    private ProbeNoHealthyBackendsBehavior noHealthyBackendsBehavior;
    @JsonProperty(value="numberOfProbes")
    private Integer numberOfProbes;
    @JsonProperty(value="probeThreshold")
    private Integer probeThreshold;
    @JsonProperty(value="requestPath")
    private String requestPath;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ProbePropertiesFormat.class);

    public List<SubResource> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    public ProbeProtocol protocol() {
        return this.protocol;
    }

    public ProbePropertiesFormat withProtocol(ProbeProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public int port() {
        return this.port;
    }

    public ProbePropertiesFormat withPort(int port) {
        this.port = port;
        return this;
    }

    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public ProbePropertiesFormat withIntervalInSeconds(Integer intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
        return this;
    }

    public ProbeNoHealthyBackendsBehavior noHealthyBackendsBehavior() {
        return this.noHealthyBackendsBehavior;
    }

    public ProbePropertiesFormat withNoHealthyBackendsBehavior(ProbeNoHealthyBackendsBehavior noHealthyBackendsBehavior) {
        this.noHealthyBackendsBehavior = noHealthyBackendsBehavior;
        return this;
    }

    public Integer numberOfProbes() {
        return this.numberOfProbes;
    }

    public ProbePropertiesFormat withNumberOfProbes(Integer numberOfProbes) {
        this.numberOfProbes = numberOfProbes;
        return this;
    }

    public Integer probeThreshold() {
        return this.probeThreshold;
    }

    public ProbePropertiesFormat withProbeThreshold(Integer probeThreshold) {
        this.probeThreshold = probeThreshold;
        return this;
    }

    public String requestPath() {
        return this.requestPath;
    }

    public ProbePropertiesFormat withRequestPath(String requestPath) {
        this.requestPath = requestPath;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model ProbePropertiesFormat"));
        }
    }
}

