/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.Access;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteFilterRuleType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RouteFilterRulePropertiesFormat {
    @JsonProperty(value="access", required=true)
    private Access access;
    @JsonProperty(value="routeFilterRuleType", required=true)
    private RouteFilterRuleType routeFilterRuleType;
    @JsonProperty(value="communities", required=true)
    private List<String> communities;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(RouteFilterRulePropertiesFormat.class);

    public Access access() {
        return this.access;
    }

    public RouteFilterRulePropertiesFormat withAccess(Access access) {
        this.access = access;
        return this;
    }

    public RouteFilterRuleType routeFilterRuleType() {
        return this.routeFilterRuleType;
    }

    public RouteFilterRulePropertiesFormat withRouteFilterRuleType(RouteFilterRuleType routeFilterRuleType) {
        this.routeFilterRuleType = routeFilterRuleType;
        return this;
    }

    public List<String> communities() {
        return this.communities;
    }

    public RouteFilterRulePropertiesFormat withCommunities(List<String> communities) {
        this.communities = communities;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.access() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property access in model RouteFilterRulePropertiesFormat"));
        }
        if (this.routeFilterRuleType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property routeFilterRuleType in model RouteFilterRulePropertiesFormat"));
        }
        if (this.communities() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property communities in model RouteFilterRulePropertiesFormat"));
        }
    }
}

