/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteNextHopType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class RoutePropertiesFormat {
    @JsonProperty(value="addressPrefix")
    private String addressPrefix;
    @JsonProperty(value="nextHopType", required=true)
    private RouteNextHopType nextHopType;
    @JsonProperty(value="nextHopIpAddress")
    private String nextHopIpAddress;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="hasBgpOverride")
    private Boolean hasBgpOverride;
    private static final ClientLogger LOGGER = new ClientLogger(RoutePropertiesFormat.class);

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public RoutePropertiesFormat withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    public RouteNextHopType nextHopType() {
        return this.nextHopType;
    }

    public RoutePropertiesFormat withNextHopType(RouteNextHopType nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    public String nextHopIpAddress() {
        return this.nextHopIpAddress;
    }

    public RoutePropertiesFormat withNextHopIpAddress(String nextHopIpAddress) {
        this.nextHopIpAddress = nextHopIpAddress;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean hasBgpOverride() {
        return this.hasBgpOverride;
    }

    public RoutePropertiesFormat withHasBgpOverride(Boolean hasBgpOverride) {
        this.hasBgpOverride = hasBgpOverride;
        return this;
    }

    public void validate() {
        if (this.nextHopType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property nextHopType in model RoutePropertiesFormat"));
        }
    }
}

