/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VngClientConnectionConfigurationProperties {
    @JsonProperty(value="vpnClientAddressPool", required=true)
    private AddressSpace vpnClientAddressPool;
    @JsonProperty(value="virtualNetworkGatewayPolicyGroups", required=true)
    private List<SubResource> virtualNetworkGatewayPolicyGroups;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(VngClientConnectionConfigurationProperties.class);

    public AddressSpace vpnClientAddressPool() {
        return this.vpnClientAddressPool;
    }

    public VngClientConnectionConfigurationProperties withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        this.vpnClientAddressPool = vpnClientAddressPool;
        return this;
    }

    public List<SubResource> virtualNetworkGatewayPolicyGroups() {
        return this.virtualNetworkGatewayPolicyGroups;
    }

    public VngClientConnectionConfigurationProperties withVirtualNetworkGatewayPolicyGroups(List<SubResource> virtualNetworkGatewayPolicyGroups) {
        this.virtualNetworkGatewayPolicyGroups = virtualNetworkGatewayPolicyGroups;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.vpnClientAddressPool() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vpnClientAddressPool in model VngClientConnectionConfigurationProperties"));
        }
        this.vpnClientAddressPool().validate();
        if (this.virtualNetworkGatewayPolicyGroups() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualNetworkGatewayPolicyGroups in model VngClientConnectionConfigurationProperties"));
        }
    }
}

