/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.resourcemanager.network.fluent.models.AdminPropertiesFormat;
import com.azure.resourcemanager.network.fluent.models.BaseAdminRuleInner;
import com.azure.resourcemanager.network.models.AddressPrefixItem;
import com.azure.resourcemanager.network.models.AdminRuleKind;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleAccess;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleDirection;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleProtocol;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="kind", defaultImpl=AdminRule.class, visible=true)
@JsonTypeName(value="Custom")
public final class AdminRule
extends BaseAdminRuleInner {
    @JsonTypeId
    @JsonProperty(value="kind", required=true)
    private AdminRuleKind kind = AdminRuleKind.CUSTOM;
    @JsonProperty(value="properties")
    private AdminPropertiesFormat innerProperties;

    @Override
    public AdminRuleKind kind() {
        return this.kind;
    }

    private AdminPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public AdminRule withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public SecurityConfigurationRuleProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public AdminRule withProtocol(SecurityConfigurationRuleProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public List<AddressPrefixItem> sources() {
        return this.innerProperties() == null ? null : this.innerProperties().sources();
    }

    public AdminRule withSources(List<AddressPrefixItem> sources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withSources(sources);
        return this;
    }

    public List<AddressPrefixItem> destinations() {
        return this.innerProperties() == null ? null : this.innerProperties().destinations();
    }

    public AdminRule withDestinations(List<AddressPrefixItem> destinations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDestinations(destinations);
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRanges();
    }

    public AdminRule withSourcePortRanges(List<String> sourcePortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withSourcePortRanges(sourcePortRanges);
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRanges();
    }

    public AdminRule withDestinationPortRanges(List<String> destinationPortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDestinationPortRanges(destinationPortRanges);
        return this;
    }

    public SecurityConfigurationRuleAccess access() {
        return this.innerProperties() == null ? null : this.innerProperties().access();
    }

    public AdminRule withAccess(SecurityConfigurationRuleAccess access) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withAccess(access);
        return this;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().priority());
    }

    public AdminRule withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public SecurityConfigurationRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    public AdminRule withDirection(SecurityConfigurationRuleDirection direction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDirection(direction);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

