/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AdminRule;
import com.azure.resourcemanager.network.models.AdminRuleKind;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.DefaultAdminRule;
import java.io.IOException;

public class BaseAdminRuleInner
extends ChildResource {
    private AdminRuleKind kind = AdminRuleKind.fromString("BaseAdminRule");
    private SystemData systemData;
    private String id;
    private String name;
    private String type;
    private String etag;

    public AdminRuleKind kind() {
        return this.kind;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    BaseAdminRuleInner withSystemData(SystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static BaseAdminRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (BaseAdminRuleInner)((Object)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                BaseAdminRuleInner baseAdminRuleInner;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Custom".equals(discriminatorValue)) {
                    baseAdminRuleInner = AdminRule.fromJson(readerToUse.reset());
                    return baseAdminRuleInner;
                }
                if ("Default".equals(discriminatorValue)) {
                    baseAdminRuleInner = DefaultAdminRule.fromJson(readerToUse.reset());
                    return baseAdminRuleInner;
                }
                baseAdminRuleInner = BaseAdminRuleInner.fromJsonKnownDiscriminator(readerToUse.reset());
                return baseAdminRuleInner;
            }
        }));
    }

    static BaseAdminRuleInner fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (BaseAdminRuleInner)((Object)jsonReader.readObject(reader -> {
            BaseAdminRuleInner deserializedBaseAdminRuleInner = new BaseAdminRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBaseAdminRuleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBaseAdminRuleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBaseAdminRuleInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedBaseAdminRuleInner.etag = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedBaseAdminRuleInner.kind = AdminRuleKind.fromString(reader.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBaseAdminRuleInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBaseAdminRuleInner;
        }));
    }
}

