/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteServiceProviderPropertiesFormat;
import com.azure.resourcemanager.network.models.ExpressRouteServiceProviderBandwidthsOffered;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ExpressRouteServiceProviderInner
extends Resource {
    private ExpressRouteServiceProviderPropertiesFormat innerProperties;
    private String id;
    private String name;
    private String type;

    private ExpressRouteServiceProviderPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public ExpressRouteServiceProviderInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ExpressRouteServiceProviderInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ExpressRouteServiceProviderInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<String> peeringLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().peeringLocations();
    }

    public ExpressRouteServiceProviderInner withPeeringLocations(List<String> peeringLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteServiceProviderPropertiesFormat();
        }
        this.innerProperties().withPeeringLocations(peeringLocations);
        return this;
    }

    public List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered() {
        return this.innerProperties() == null ? null : this.innerProperties().bandwidthsOffered();
    }

    public ExpressRouteServiceProviderInner withBandwidthsOffered(List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteServiceProviderPropertiesFormat();
        }
        this.innerProperties().withBandwidthsOffered(bandwidthsOffered);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteServiceProviderInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteServiceProviderInner)((Object)jsonReader.readObject(reader -> {
            ExpressRouteServiceProviderInner deserializedExpressRouteServiceProviderInner = new ExpressRouteServiceProviderInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedExpressRouteServiceProviderInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderInner.innerProperties = ExpressRouteServiceProviderPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteServiceProviderInner;
        }));
    }
}

