/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.HubRoute;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class HubRouteTableProperties
implements JsonSerializable<HubRouteTableProperties> {
    private List<HubRoute> routes;
    private List<String> labels;
    private List<String> associatedConnections;
    private List<String> propagatingConnections;
    private ProvisioningState provisioningState;

    public List<HubRoute> routes() {
        return this.routes;
    }

    public HubRouteTableProperties withRoutes(List<HubRoute> routes) {
        this.routes = routes;
        return this;
    }

    public List<String> labels() {
        return this.labels;
    }

    public HubRouteTableProperties withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public List<String> associatedConnections() {
        return this.associatedConnections;
    }

    public List<String> propagatingConnections() {
        return this.propagatingConnections;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("routes", this.routes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static HubRouteTableProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HubRouteTableProperties)jsonReader.readObject(reader -> {
            HubRouteTableProperties deserializedHubRouteTableProperties = new HubRouteTableProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("routes".equals(fieldName)) {
                    List routes;
                    deserializedHubRouteTableProperties.routes = routes = reader.readArray(reader1 -> HubRoute.fromJson(reader1));
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    List labels;
                    deserializedHubRouteTableProperties.labels = labels = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("associatedConnections".equals(fieldName)) {
                    List associatedConnections;
                    deserializedHubRouteTableProperties.associatedConnections = associatedConnections = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("propagatingConnections".equals(fieldName)) {
                    List propagatingConnections;
                    deserializedHubRouteTableProperties.propagatingConnections = propagatingConnections = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedHubRouteTableProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHubRouteTableProperties;
        });
    }
}

