/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.IpGroupPropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class IpGroupInner
extends Resource {
    private IpGroupPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String name;
    private String type;

    private IpGroupPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public IpGroupInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public IpGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public IpGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<String> ipAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddresses();
    }

    public IpGroupInner withIpAddresses(List<String> ipAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpGroupPropertiesFormat();
        }
        this.innerProperties().withIpAddresses(ipAddresses);
        return this;
    }

    public List<SubResource> firewalls() {
        return this.innerProperties() == null ? null : this.innerProperties().firewalls();
    }

    public List<SubResource> firewallPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().firewallPolicies();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static IpGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (IpGroupInner)((Object)jsonReader.readObject(reader -> {
            IpGroupInner deserializedIpGroupInner = new IpGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIpGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIpGroupInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedIpGroupInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIpGroupInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIpGroupInner.innerProperties = IpGroupPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedIpGroupInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedIpGroupInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpGroupInner;
        }));
    }
}

