/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.network.fluent.models.PrivateLinkServiceIpConfigurationInner;
import com.azure.resourcemanager.network.models.PrivateLinkServicePropertiesAutoApproval;
import com.azure.resourcemanager.network.models.PrivateLinkServicePropertiesVisibility;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class PrivateLinkServiceProperties
implements JsonSerializable<PrivateLinkServiceProperties> {
    private List<FrontendIpConfigurationInner> loadBalancerFrontendIpConfigurations;
    private List<PrivateLinkServiceIpConfigurationInner> ipConfigurations;
    private List<NetworkInterfaceInner> networkInterfaces;
    private ProvisioningState provisioningState;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private PrivateLinkServicePropertiesVisibility visibility;
    private PrivateLinkServicePropertiesAutoApproval autoApproval;
    private List<String> fqdns;
    private String alias;
    private Boolean enableProxyProtocol;

    public List<FrontendIpConfigurationInner> loadBalancerFrontendIpConfigurations() {
        return this.loadBalancerFrontendIpConfigurations;
    }

    public PrivateLinkServiceProperties withLoadBalancerFrontendIpConfigurations(List<FrontendIpConfigurationInner> loadBalancerFrontendIpConfigurations) {
        this.loadBalancerFrontendIpConfigurations = loadBalancerFrontendIpConfigurations;
        return this;
    }

    public List<PrivateLinkServiceIpConfigurationInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    public PrivateLinkServiceProperties withIpConfigurations(List<PrivateLinkServiceIpConfigurationInner> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.networkInterfaces;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PrivateLinkServicePropertiesVisibility visibility() {
        return this.visibility;
    }

    public PrivateLinkServiceProperties withVisibility(PrivateLinkServicePropertiesVisibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public PrivateLinkServicePropertiesAutoApproval autoApproval() {
        return this.autoApproval;
    }

    public PrivateLinkServiceProperties withAutoApproval(PrivateLinkServicePropertiesAutoApproval autoApproval) {
        this.autoApproval = autoApproval;
        return this;
    }

    public List<String> fqdns() {
        return this.fqdns;
    }

    public PrivateLinkServiceProperties withFqdns(List<String> fqdns) {
        this.fqdns = fqdns;
        return this;
    }

    public String alias() {
        return this.alias;
    }

    public Boolean enableProxyProtocol() {
        return this.enableProxyProtocol;
    }

    public PrivateLinkServiceProperties withEnableProxyProtocol(Boolean enableProxyProtocol) {
        this.enableProxyProtocol = enableProxyProtocol;
        return this;
    }

    public void validate() {
        if (this.loadBalancerFrontendIpConfigurations() != null) {
            this.loadBalancerFrontendIpConfigurations().forEach(e -> e.validate());
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.visibility() != null) {
            this.visibility().validate();
        }
        if (this.autoApproval() != null) {
            this.autoApproval().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("loadBalancerFrontendIpConfigurations", this.loadBalancerFrontendIpConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("visibility", (JsonSerializable)this.visibility);
        jsonWriter.writeJsonField("autoApproval", (JsonSerializable)this.autoApproval);
        jsonWriter.writeArrayField("fqdns", this.fqdns, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("enableProxyProtocol", this.enableProxyProtocol);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkServiceProperties)jsonReader.readObject(reader -> {
            PrivateLinkServiceProperties deserializedPrivateLinkServiceProperties = new PrivateLinkServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loadBalancerFrontendIpConfigurations".equals(fieldName)) {
                    List loadBalancerFrontendIpConfigurations;
                    deserializedPrivateLinkServiceProperties.loadBalancerFrontendIpConfigurations = loadBalancerFrontendIpConfigurations = reader.readArray(reader1 -> FrontendIpConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedPrivateLinkServiceProperties.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> PrivateLinkServiceIpConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("networkInterfaces".equals(fieldName)) {
                    List networkInterfaces;
                    deserializedPrivateLinkServiceProperties.networkInterfaces = networkInterfaces = reader.readArray(reader1 -> NetworkInterfaceInner.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateLinkServiceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedPrivateLinkServiceProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("visibility".equals(fieldName)) {
                    deserializedPrivateLinkServiceProperties.visibility = PrivateLinkServicePropertiesVisibility.fromJson(reader);
                    continue;
                }
                if ("autoApproval".equals(fieldName)) {
                    deserializedPrivateLinkServiceProperties.autoApproval = PrivateLinkServicePropertiesAutoApproval.fromJson(reader);
                    continue;
                }
                if ("fqdns".equals(fieldName)) {
                    List fqdns;
                    deserializedPrivateLinkServiceProperties.fqdns = fqdns = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("alias".equals(fieldName)) {
                    deserializedPrivateLinkServiceProperties.alias = reader.getString();
                    continue;
                }
                if ("enableProxyProtocol".equals(fieldName)) {
                    deserializedPrivateLinkServiceProperties.enableProxyProtocol = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkServiceProperties;
        });
    }
}

