/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NatGatewayInner;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressPropertiesFormatInner;
import com.azure.resourcemanager.network.models.DdosSettings;
import com.azure.resourcemanager.network.models.DeleteOptions;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpTag;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.PublicIpAddressDnsSettings;
import com.azure.resourcemanager.network.models.PublicIpAddressMigrationPhase;
import com.azure.resourcemanager.network.models.PublicIpAddressSku;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PublicIpAddressInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private PublicIpAddressSku sku;
    private PublicIpAddressPropertiesFormatInner innerProperties;
    private String etag;
    private List<String> zones;
    private String id;
    private String name;
    private String type;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public PublicIpAddressInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public PublicIpAddressSku sku() {
        return this.sku;
    }

    public PublicIpAddressInner withSku(PublicIpAddressSku sku) {
        this.sku = sku;
        return this;
    }

    private PublicIpAddressPropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public List<String> zones() {
        return this.zones;
    }

    public PublicIpAddressInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String id() {
        return this.id;
    }

    public PublicIpAddressInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public PublicIpAddressInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public PublicIpAddressInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public IpAllocationMethod publicIpAllocationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAllocationMethod();
    }

    public PublicIpAddressInner withPublicIpAllocationMethod(IpAllocationMethod publicIpAllocationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withPublicIpAllocationMethod(publicIpAllocationMethod);
        return this;
    }

    public IpVersion publicIpAddressVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddressVersion();
    }

    public PublicIpAddressInner withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withPublicIpAddressVersion(publicIpAddressVersion);
        return this;
    }

    public IpConfigurationInner ipConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfiguration();
    }

    public PublicIpAddressDnsSettings dnsSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSettings();
    }

    public PublicIpAddressInner withDnsSettings(PublicIpAddressDnsSettings dnsSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withDnsSettings(dnsSettings);
        return this;
    }

    public DdosSettings ddosSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().ddosSettings();
    }

    public PublicIpAddressInner withDdosSettings(DdosSettings ddosSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withDdosSettings(ddosSettings);
        return this;
    }

    public List<IpTag> ipTags() {
        return this.innerProperties() == null ? null : this.innerProperties().ipTags();
    }

    public PublicIpAddressInner withIpTags(List<IpTag> ipTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withIpTags(ipTags);
        return this;
    }

    public String ipAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddress();
    }

    public PublicIpAddressInner withIpAddress(String ipAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withIpAddress(ipAddress);
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpPrefix();
    }

    public PublicIpAddressInner withPublicIpPrefix(SubResource publicIpPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withPublicIpPrefix(publicIpPrefix);
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().idleTimeoutInMinutes();
    }

    public PublicIpAddressInner withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withIdleTimeoutInMinutes(idleTimeoutInMinutes);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PublicIpAddressInner servicePublicIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().servicePublicIpAddress();
    }

    public PublicIpAddressInner withServicePublicIpAddress(PublicIpAddressInner servicePublicIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withServicePublicIpAddress(servicePublicIpAddress);
        return this;
    }

    public NatGatewayInner natGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().natGateway();
    }

    public PublicIpAddressInner withNatGateway(NatGatewayInner natGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withNatGateway(natGateway);
        return this;
    }

    public PublicIpAddressMigrationPhase migrationPhase() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationPhase();
    }

    public PublicIpAddressInner withMigrationPhase(PublicIpAddressMigrationPhase migrationPhase) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withMigrationPhase(migrationPhase);
        return this;
    }

    public PublicIpAddressInner linkedPublicIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedPublicIpAddress();
    }

    public PublicIpAddressInner withLinkedPublicIpAddress(PublicIpAddressInner linkedPublicIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withLinkedPublicIpAddress(linkedPublicIpAddress);
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteOption();
    }

    public PublicIpAddressInner withDeleteOption(DeleteOptions deleteOption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpAddressPropertiesFormatInner();
        }
        this.innerProperties().withDeleteOption(deleteOption);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static PublicIpAddressInner fromJson(JsonReader jsonReader) throws IOException {
        return (PublicIpAddressInner)((Object)jsonReader.readObject(reader -> {
            PublicIpAddressInner deserializedPublicIpAddressInner = new PublicIpAddressInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPublicIpAddressInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPublicIpAddressInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPublicIpAddressInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPublicIpAddressInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedPublicIpAddressInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedPublicIpAddressInner.sku = PublicIpAddressSku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPublicIpAddressInner.innerProperties = PublicIpAddressPropertiesFormatInner.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedPublicIpAddressInner.etag = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedPublicIpAddressInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedPublicIpAddressInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPublicIpAddressInner;
        }));
    }
}

