/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.azure.resourcemanager.network.fluent.models.WebApplicationFirewallPolicyPropertiesFormat;
import com.azure.resourcemanager.network.models.ManagedRulesDefinition;
import com.azure.resourcemanager.network.models.PolicySettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.WebApplicationFirewallCustomRule;
import com.azure.resourcemanager.network.models.WebApplicationFirewallPolicyResourceState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WebApplicationFirewallPolicyInner
extends Resource {
    private WebApplicationFirewallPolicyPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String name;
    private String type;

    private WebApplicationFirewallPolicyPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public WebApplicationFirewallPolicyInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public WebApplicationFirewallPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public WebApplicationFirewallPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public PolicySettings policySettings() {
        return this.innerProperties() == null ? null : this.innerProperties().policySettings();
    }

    public WebApplicationFirewallPolicyInner withPolicySettings(PolicySettings policySettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebApplicationFirewallPolicyPropertiesFormat();
        }
        this.innerProperties().withPolicySettings(policySettings);
        return this;
    }

    public List<WebApplicationFirewallCustomRule> customRules() {
        return this.innerProperties() == null ? null : this.innerProperties().customRules();
    }

    public WebApplicationFirewallPolicyInner withCustomRules(List<WebApplicationFirewallCustomRule> customRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebApplicationFirewallPolicyPropertiesFormat();
        }
        this.innerProperties().withCustomRules(customRules);
        return this;
    }

    public List<ApplicationGatewayInner> applicationGateways() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationGateways();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public WebApplicationFirewallPolicyResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public ManagedRulesDefinition managedRules() {
        return this.innerProperties() == null ? null : this.innerProperties().managedRules();
    }

    public WebApplicationFirewallPolicyInner withManagedRules(ManagedRulesDefinition managedRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebApplicationFirewallPolicyPropertiesFormat();
        }
        this.innerProperties().withManagedRules(managedRules);
        return this;
    }

    public List<SubResource> httpListeners() {
        return this.innerProperties() == null ? null : this.innerProperties().httpListeners();
    }

    public List<SubResource> pathBasedRules() {
        return this.innerProperties() == null ? null : this.innerProperties().pathBasedRules();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static WebApplicationFirewallPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (WebApplicationFirewallPolicyInner)((Object)jsonReader.readObject(reader -> {
            WebApplicationFirewallPolicyInner deserializedWebApplicationFirewallPolicyInner = new WebApplicationFirewallPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWebApplicationFirewallPolicyInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyInner.innerProperties = WebApplicationFirewallPolicyPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebApplicationFirewallPolicyInner;
        }));
    }
}

